/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection.constructor;

import io.github.portlek.reflection.RefConstructed;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class ConstructorOf<T>
implements RefConstructed<T> {
    @NotNull
    private final Constructor<T> constructor;

    @Override
    public <A extends Annotation> Optional<A> annotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.constructor.getDeclaredAnnotation(annotationClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Optional<T> create(Object ... parameters) {
        boolean accessible = this.constructor.isAccessible();
        this.constructor.setAccessible(true);
        try {
            Optional<T> optional = Optional.of(this.constructor.newInstance(parameters));
            this.constructor.setAccessible(accessible);
            return optional;
        }
        catch (Throwable throwable) {
            this.constructor.setAccessible(accessible);
            throw throwable;
        }
    }

    public ConstructorOf(@NotNull Constructor<T> constructor) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        this.constructor = constructor;
    }
}

