/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection.clazz;

import io.github.portlek.reflection.RefClass;
import io.github.portlek.reflection.RefConstructed;
import io.github.portlek.reflection.RefField;
import io.github.portlek.reflection.RefMethod;
import io.github.portlek.reflection.constructor.ConstructorOf;
import io.github.portlek.reflection.field.FieldOf;
import io.github.portlek.reflection.method.MethodOf;
import io.github.portlek.reflection.parameterized.ParameterizedOf;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ClassOf<T>
implements RefClass<T> {
    @NotNull
    private final Class<T> clazz;

    public ClassOf(@NotNull T object) {
        this(object.getClass());
    }

    public ClassOf(@NotNull String classname) throws ClassNotFoundException {
        this(Class.forName(classname));
    }

    @Override
    @NotNull
    public Class<T> realClass() {
        return this.clazz;
    }

    @Override
    public boolean isInstance(@NotNull Object object) {
        return this.clazz.isInstance(object);
    }

    @Override
    @NotNull
    public Optional<RefMethod> primitiveMethod(@NotNull String name, Object ... types) {
        return this.getMethod0(name, true, types);
    }

    @Override
    @NotNull
    public Optional<RefMethod> method(@NotNull String name, Object ... types) {
        return this.getMethod0(name, false, types);
    }

    @Override
    @NotNull
    public Optional<RefMethod> primitiveMethodByParameter(Object ... types) {
        return this.findMethod0(true, types);
    }

    @Override
    @NotNull
    public Optional<RefMethod> methodByParameter(Object ... types) {
        return this.findMethod0(false, types);
    }

    @Override
    @NotNull
    public Optional<RefMethod> methodByName(String ... names) {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.clazz.getMethods()));
        methods.addAll(Arrays.asList(this.clazz.getDeclaredMethods()));
        return methods.stream().filter(Objects::nonNull).filter(method -> Arrays.stream(names).findFirst().map(name -> method.getName().equals(name)).orElse(false)).findFirst().map(MethodOf::new);
    }

    @Override
    @NotNull
    public <X> Optional<RefMethod> methodByReturnType(@NotNull RefClass<X> type) {
        return this.methodByReturnType(type.realClass());
    }

    @Override
    @NotNull
    public Optional<RefMethod> methodByReturnType(@NotNull Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.clazz.getMethods()));
        methods.addAll(Arrays.asList(this.clazz.getDeclaredMethods()));
        return methods.stream().filter(Objects::nonNull).filter(method -> type.equals(method.getReturnType())).findFirst().map(MethodOf::new);
    }

    @Override
    @NotNull
    public Optional<RefConstructed<T>> primitiveConstructor(Object ... types) {
        return this.getConstructor0(true, types);
    }

    @Override
    @NotNull
    public Optional<RefConstructed<T>> constructor(Object ... types) {
        return this.getConstructor0(false, types);
    }

    @Override
    @NotNull
    public Optional<RefConstructed<T>> constructor(int number) {
        ArrayList constructors = new ArrayList(Arrays.asList(this.clazz.getConstructors()));
        constructors.addAll(Arrays.asList(this.clazz.getDeclaredConstructors()));
        return constructors.stream().filter(Objects::nonNull).filter(constructor -> constructor.getParameterTypes().length == number).findFirst().map(constructor -> new ConstructorOf(constructor));
    }

    @Override
    @NotNull
    public Optional<RefField> field(@NotNull String name) {
        try {
            return Optional.of(new FieldOf(this.clazz.getField(name)));
        }
        catch (NoSuchFieldException ignored) {
            try {
                return Optional.of(new FieldOf(this.clazz.getDeclaredField(name)));
            }
            catch (NoSuchFieldException e) {
                return Optional.empty();
            }
        }
    }

    @Override
    @NotNull
    public <X> Optional<RefField> field(@NotNull RefClass<X> type) {
        return this.field(type.realClass());
    }

    @Override
    @NotNull
    public Optional<RefField> field(@NotNull Class<?> type) {
        List<RefField> fields = this.fields();
        fields.addAll(this.declaredFields());
        return fields.stream().filter(Objects::nonNull).filter(field -> type.equals(field.type())).findFirst();
    }

    @Override
    @NotNull
    public List<RefField> fields() {
        return Arrays.stream(this.clazz.getFields()).map(FieldOf::new).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<RefField> declaredFields() {
        return Arrays.stream(this.clazz.getDeclaredFields()).map(FieldOf::new).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<RefMethod> methods() {
        return Arrays.stream(this.clazz.getMethods()).map(MethodOf::new).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<RefMethod> declaredMethods() {
        return Arrays.stream(this.clazz.getDeclaredMethods()).map(MethodOf::new).collect(Collectors.toList());
    }

    @Override
    public <A extends Annotation> Optional<A> annotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.clazz.getDeclaredAnnotation(annotationClass));
    }

    @NotNull
    private Optional<RefMethod> getMethod0(@NotNull String name, boolean primitive, Object ... types) {
        ParameterizedOf<Function<Class[], Optional>> parameter = new ParameterizedOf<Function<Class[], Optional>>(primitive, types);
        return (Optional)parameter.apply(classes -> {
            try {
                return Optional.of(new MethodOf(this.clazz.getMethod(name, (Class<?>)classes)));
            }
            catch (NoSuchMethodException e) {
                return (Optional)parameter.apply(declaredclasses -> {
                    try {
                        return Optional.of(new MethodOf(this.clazz.getDeclaredMethod(name, (Class<?>)declaredclasses)));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return Optional.empty();
                    }
                });
            }
        });
    }

    @NotNull
    private Optional<RefConstructed<T>> getConstructor0(boolean primitive, Object ... types) {
        ParameterizedOf<Function<Class[], Optional>> parameter = new ParameterizedOf<Function<Class[], Optional>>(primitive, types);
        return (Optional)parameter.apply(classes -> {
            try {
                return Optional.of(new ConstructorOf<T>(this.clazz.getConstructor((Class<?>)classes)));
            }
            catch (NoSuchMethodException e) {
                return (Optional)parameter.apply(declaredclasses -> {
                    try {
                        return Optional.of(new ConstructorOf<T>(this.clazz.getDeclaredConstructor((Class<?>)declaredclasses)));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return Optional.empty();
                    }
                });
            }
        });
    }

    @NotNull
    private Optional<RefMethod> findMethod0(boolean primitive, Object ... types) {
        ParameterizedOf<Function<Class[], Optional>> parameter = new ParameterizedOf<Function<Class[], Optional>>(primitive, types);
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.clazz.getMethods()));
        methods.addAll(Arrays.asList(this.clazz.getDeclaredMethods()));
        ArrayList classlist = new ArrayList();
        parameter.apply(classes -> {
            classlist.addAll(Arrays.asList(classes));
            return Optional.empty();
        });
        block0: for (Method method : methods) {
            Object[] methodtypes = method.getParameterTypes();
            if (methodtypes.length != classlist.size()) continue;
            for (int index = 0; index < classlist.size(); ++index) {
                if (!Arrays.equals(classlist.toArray(new Class[0]), methodtypes)) continue block0;
            }
            return Optional.of(new MethodOf(method));
        }
        return Optional.empty();
    }

    public ClassOf(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.clazz = clazz;
    }
}

