/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.yaml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.configuration.FileConfiguration;
import io.github.portlek.configs.exceptions.InvalidConfigurationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Yaml
extends FileConfiguration {
    private static final ObjectMapper MAPPER = new YAMLMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final MapType MAP_TYPE = MAPPER.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);

    public void loadFromString(@NotNull String contents) throws InvalidConfigurationException {
        Map input;
        try {
            input = (Map)MAPPER.readValue(contents.isEmpty() ? "{}" : contents, (JavaType)MAP_TYPE);
        }
        catch (JsonProcessingException e) {
            throw new InvalidConfigurationException((Throwable)e);
        }
        this.convertMapsToSections(input, (ConfigurationSection)this);
    }

    public String saveToString() throws IOException {
        return MAPPER.writeValueAsString(this.getMapValues(false));
    }

    private void convertMapsToSections(Map<?, ?> input, ConfigurationSection section) {
        input.forEach((key1, value) -> {
            String key = key1.toString();
            if (value instanceof Map) {
                this.convertMapsToSections((Map)value, section.createSection(key));
            } else {
                section.set(key, value);
            }
        });
    }
}

