/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.tree;

import io.github.portlek.configs.tree.FileConfiguration;
import io.github.portlek.configs.tree.MemoryConfiguration;
import io.github.portlek.configs.tree.MemoryConfigurationOptions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class FileConfigurationOptions
extends MemoryConfigurationOptions {
    private Charset charset = StandardCharsets.UTF_8;
    private boolean copyHeader = true;
    private String header = null;

    protected FileConfigurationOptions(MemoryConfiguration configuration) {
        super(configuration);
    }

    public Charset charset() {
        return this.charset;
    }

    public FileConfigurationOptions charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public FileConfiguration configuration() {
        return (FileConfiguration)super.configuration();
    }

    @Override
    public FileConfigurationOptions copyDefaults(boolean value) {
        super.copyDefaults(value);
        return this;
    }

    @Override
    public FileConfigurationOptions pathSeparator(char value) {
        super.pathSeparator(value);
        return this;
    }

    public boolean copyHeader() {
        return this.copyHeader;
    }

    public FileConfigurationOptions copyHeader(boolean value) {
        this.copyHeader = value;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.charset, this.header, this.copyHeader);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileConfigurationOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileConfigurationOptions that = (FileConfigurationOptions)o;
        return this.copyHeader == that.copyHeader && Objects.equals(this.charset, that.charset) && Objects.equals(this.header, that.header);
    }

    public FileConfigurationOptions header(String value) {
        this.header = value;
        return this;
    }

    public String header() {
        return this.header;
    }

    public boolean isUnicode() {
        return this.charset.name().startsWith("UTF");
    }
}

