/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.file;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.simpleyaml.configuration.MemoryConfiguration;
import org.simpleyaml.configuration.MemoryConfigurationOptions;
import org.simpleyaml.configuration.file.FileConfiguration;

public class FileConfigurationOptions
extends MemoryConfigurationOptions {
    private Charset charset = StandardCharsets.UTF_8;
    private String header = null;
    private boolean copyHeader = true;

    protected FileConfigurationOptions(MemoryConfiguration configuration) {
        super(configuration);
    }

    @Override
    public FileConfiguration configuration() {
        return (FileConfiguration)super.configuration();
    }

    @Override
    public FileConfigurationOptions pathSeparator(char value) {
        super.pathSeparator(value);
        return this;
    }

    @Override
    public FileConfigurationOptions copyDefaults(boolean value) {
        super.copyDefaults(value);
        return this;
    }

    public Charset charset() {
        return this.charset;
    }

    public FileConfigurationOptions charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public boolean isUnicode() {
        return this.charset.name().startsWith("UTF");
    }

    public String header() {
        return this.header;
    }

    public FileConfigurationOptions header(String value) {
        this.header = value;
        return this;
    }

    public boolean copyHeader() {
        return this.copyHeader;
    }

    public FileConfigurationOptions copyHeader(boolean value) {
        this.copyHeader = value;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileConfigurationOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileConfigurationOptions that = (FileConfigurationOptions)o;
        return this.copyHeader == that.copyHeader && Objects.equals(this.charset, that.charset) && Objects.equals(this.header, that.header);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.charset, this.header, this.copyHeader);
    }
}

