/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.comments;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simpleyaml.configuration.comments.CommentReader;
import org.simpleyaml.configuration.comments.KeyTree;
import org.simpleyaml.configuration.file.YamlConfigurationOptions;

public class CommentParser
extends CommentReader {
    private static final Pattern SIDE_COMMENT_REGEX = Pattern.compile("^[ \\t]*[^#\\s].*?([ \\t]*#.*)");
    private StringBuilder currentComment;

    public CommentParser(YamlConfigurationOptions options, Reader reader) {
        super(options, reader);
    }

    public void parse() throws IOException {
        while (this.nextLine()) {
            if (this.isBlank() || this.isComment()) {
                this.appendLine();
                continue;
            }
            this.trackComment();
        }
        this.trackComment();
        this.reader.close();
    }

    private void appendLine() {
        if (this.currentComment == null) {
            this.currentComment = new StringBuilder(this.currentLine);
        } else {
            this.currentComment.append(this.currentLine);
        }
        this.currentComment.append('\n');
    }

    private void trackComment() {
        KeyTree.Node node = this.track();
        if (this.currentComment != null) {
            node.setComment(this.currentComment.toString());
            this.currentComment = null;
        }
        this.setSideComment(node);
    }

    private void setSideComment(KeyTree.Node node) {
        Matcher sideCommentMatcher;
        if (this.currentLine != null && (sideCommentMatcher = SIDE_COMMENT_REGEX.matcher(this.currentLine)).matches()) {
            node.setSideComment(sideCommentMatcher.group(1));
        }
    }
}

