/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleyaml.configuration.comments.CommentDumper;
import org.simpleyaml.configuration.comments.CommentMapper;
import org.simpleyaml.configuration.comments.CommentParser;
import org.simpleyaml.configuration.comments.CommentType;
import org.simpleyaml.configuration.comments.Commentable;
import org.simpleyaml.configuration.file.YamlConfiguration;
import org.simpleyaml.exceptions.InvalidConfigurationException;
import org.simpleyaml.utils.Validate;

public class YamlFile
extends YamlConfiguration
implements Commentable {
    private File configFile;
    private CommentMapper commentMapper;
    private boolean useComments = false;

    public YamlFile() {
    }

    public YamlFile(String path) throws IllegalArgumentException {
        this.setConfigurationFile(path);
    }

    public YamlFile(File file) throws IllegalArgumentException {
        this.setConfigurationFile(file);
    }

    public YamlFile(URI uri) throws IllegalArgumentException {
        this.setConfigurationFile(uri);
    }

    public YamlFile(URL url) throws IllegalArgumentException, URISyntaxException {
        this(url.toURI());
    }

    public void save() throws IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        this.save(this.configFile);
    }

    @Override
    public String saveToString() throws IOException {
        if (this.useComments) {
            return new CommentDumper(this.options(), this.parseComments(), new StringReader(super.dump())).dump();
        }
        return super.saveToString();
    }

    private CommentMapper parseComments() throws IOException {
        if (this.commentMapper != null) {
            return this.commentMapper;
        }
        try {
            return this.parseComments(this.fileToString());
        }
        catch (InvalidConfigurationException e) {
            throw new IOException(e);
        }
    }

    private CommentMapper parseComments(String contents) throws InvalidConfigurationException {
        try {
            if (contents != null) {
                this.commentMapper = new CommentParser(this.options(), new StringReader(contents));
                ((CommentParser)this.commentMapper).parse();
            } else {
                this.commentMapper = new CommentMapper(this.options());
            }
            return this.commentMapper;
        }
        catch (IOException e) {
            throw new InvalidConfigurationException(e);
        }
    }

    @Override
    public void setComment(String path, String comment, CommentType type) {
        if (this.commentMapper == null) {
            this.useComments = true;
            this.commentMapper = new CommentMapper(this.options());
        }
        this.commentMapper.setComment(path, comment, type);
    }

    @Override
    public String getComment(String path, CommentType type) {
        return this.commentMapper != null ? this.commentMapper.getComment(path, type) : null;
    }

    public void load() throws InvalidConfigurationException, IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        this.load(this.configFile);
    }

    public void loadWithComments() throws InvalidConfigurationException, IOException {
        this.useComments = true;
        this.load();
    }

    @Override
    public void loadFromString(String contents) throws InvalidConfigurationException {
        super.loadFromString(contents);
        if (this.useComments) {
            this.parseComments(contents);
        }
    }

    public void createOrLoad() throws IOException, InvalidConfigurationException {
        this.createNewFile(false);
        this.load();
    }

    public void createOrLoadWithComments() throws IOException, InvalidConfigurationException {
        this.createNewFile(false);
        this.loadWithComments();
    }

    public boolean exists() {
        return this.configFile != null && this.configFile.exists();
    }

    public void createNewFile(boolean overwrite) throws IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        if (overwrite || !this.configFile.exists()) {
            try {
                File parents = this.configFile.getParentFile();
                if (parents != null) {
                    parents.mkdirs();
                }
                this.configFile.createNewFile();
            }
            catch (SecurityException e) {
                throw new IOException(e.getMessage(), e.getCause());
            }
        }
    }

    public void deleteFile() throws IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        if (!this.configFile.delete()) {
            throw new IOException("Failed to delete " + this.configFile);
        }
    }

    public long getSize() {
        return this.configFile.length();
    }

    public String getFilePath() {
        Validate.notNull(this.configFile, "This configuration file is null!");
        return this.configFile.getAbsolutePath();
    }

    public File getConfigurationFile() {
        return this.configFile;
    }

    public void setConfigurationFile(String path) throws IllegalArgumentException {
        Validate.notNull(path, "Path cannot be null.");
        this.setConfigFile(new File(path));
    }

    public void setConfigurationFile(URI uri) throws IllegalArgumentException {
        Validate.notNull(uri, "URI cannot be null.");
        this.setConfigFile(new File(uri));
    }

    public void setConfigurationFile(File file) throws IllegalArgumentException {
        Validate.notNull(file, "File cannot be null.");
        this.setConfigFile(file);
    }

    private void setConfigFile(File file) throws IllegalArgumentException {
        this.configFile = file;
        if (this.configFile.isDirectory()) {
            this.configFile = null;
            throw new IllegalArgumentException(this.configFile.getName() + " is a directory!");
        }
    }

    public File copyTo(String path) throws FileNotFoundException, IllegalArgumentException, IOException {
        Validate.notNull(path, "Path cannot be null.");
        File copy = new File(path);
        this.copyTo(copy);
        return copy;
    }

    public void copyTo(File file) throws FileNotFoundException, IllegalArgumentException, IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        if (!this.configFile.exists()) {
            throw new FileNotFoundException(this.configFile.getName() + " is not found in " + this.configFile.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is a directory!");
        }
        try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            Files.copy(this.configFile.toPath(), fos);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String fileToString() throws IOException {
        if (!this.exists()) {
            return null;
        }
        return new String(Files.readAllBytes(this.configFile.toPath()));
    }

    @Override
    public String toString() {
        try {
            return this.saveToString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static YamlFile loadConfiguration(File file, boolean withComments) {
        Validate.notNull(file, "File cannot be null");
        return YamlFile.load(config -> {
            config.setConfigurationFile(file);
            config.load();
        }, withComments);
    }

    public static YamlFile loadConfiguration(File file) {
        return YamlFile.loadConfiguration(file, false);
    }

    public static YamlFile loadConfiguration(InputStream stream, boolean withComments) {
        Validate.notNull(stream, "Stream cannot be null");
        return YamlFile.load(config -> config.load(stream), withComments);
    }

    public static YamlFile loadConfiguration(InputStream stream) {
        return YamlFile.loadConfiguration(stream, false);
    }

    public static YamlFile loadConfiguration(Reader reader, boolean withComments) {
        Validate.notNull(reader, "Reader cannot be null");
        return YamlFile.load(config -> config.load(reader), withComments);
    }

    public static YamlFile loadConfiguration(Reader reader) {
        return YamlFile.loadConfiguration(reader, false);
    }

    private static YamlFile load(YamlFileLoader loader, boolean withComments) {
        YamlFile config = new YamlFile();
        try {
            config.useComments = withComments;
            loader.load(config);
        }
        catch (IOException | InvalidConfigurationException ex) {
            Logger.getLogger(YamlFile.class.getName()).log(Level.SEVERE, "Cannot load configuration", ex);
        }
        return config;
    }

    private static interface YamlFileLoader {
        public void load(YamlFile var1) throws IOException, InvalidConfigurationException;
    }
}

