/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.data;

import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.DataSerializer;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public final class Position
implements DataSerializer {
    @NotNull
    private final String worldName;
    private final double x;
    private final double y;
    private final double z;
    private float pitch;
    private float yaw;

    public Position(@NotNull String worldName, int x, int y, int z) {
        this(worldName, (double)x, (double)y, (double)z);
    }

    public Position(@NotNull String worldName, int x, int y, int z, float yaw, float pitch) {
        this(worldName, (double)x, (double)y, (double)z, yaw, pitch);
    }

    @NotNull
    public static Optional<Position> deserialize(@NotNull ConfigurationSection section) {
        String world = section.getString("world");
        if (world == null) {
            return Optional.empty();
        }
        double x = section.getDouble("x");
        double y = section.getDouble("y");
        double z = section.getDouble("z");
        float yaw = Double.valueOf(section.getDouble("yaw")).floatValue();
        float pitch = Double.valueOf(section.getDouble("pitch")).floatValue();
        return Optional.of(new Position(world, x, y, z, yaw, pitch));
    }

    @NotNull
    public Optional<Location> getLocation() {
        return Optional.ofNullable(Bukkit.getWorld((String)this.worldName)).map(world -> new Location(world, this.x, this.y, this.z, this.yaw, this.pitch));
    }

    @NotNull
    public Location getLocationThrown() {
        return new Location(Objects.requireNonNull(Bukkit.getWorld((String)this.worldName), "world"), this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public void serialize(@NotNull ConfigurationSection section) {
        section.set("world", (Object)this.worldName);
        section.set("x", (Object)this.x);
        section.set("y", (Object)this.y);
        section.set("z", (Object)this.z);
        section.set("yaw", (Object)Float.valueOf(this.yaw));
        section.set("pitch", (Object)Float.valueOf(this.pitch));
    }

    public Position(@NotNull String worldName, double x, double y, double z) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Position(@NotNull String worldName, double x, double y, double z, float pitch, float yaw) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }
}

