/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection.constructor;

import io.github.portlek.reflection.RefConstructed;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class ConstructorOf<T>
implements RefConstructed<T> {
    @NotNull
    private final Constructor<T> constructor;

    public ConstructorOf(@NotNull Constructor<T> constructor) {
        this.constructor = constructor;
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.constructor.getDeclaredAnnotation(annotationClass));
    }

    @Override
    @NotNull
    public Optional<T> create(Object ... parameters) {
        boolean accessible = this.constructor.isAccessible();
        try {
            this.constructor.setAccessible(true);
            Optional<T> optional = Optional.of(this.constructor.newInstance(parameters));
            return optional;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            this.constructor.setAccessible(accessible);
        }
    }
}

