/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders;

import io.github.portlek.configs.ConfigLoader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.reflection.RefField;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlUniqueId
extends BaseFieldLoader {
    public static final Supplier<FlUniqueId> INSTANCE = FlUniqueId::new;

    @NotNull
    private static Optional<UUID> convertToUniqueId(@Nullable String raw) {
        if (raw == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(UUID.fromString(raw));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    @Override
    public boolean canLoad(@NotNull ConfigLoader loader, @NotNull RefField field) {
        return UUID.class == field.getType();
    }

    @Override
    public void onLoad(@NotNull ConfigLoader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        Optional<Object> fieldValue = field.getValue();
        ConfigurationSection section = this.getSection(loader);
        Optional<UUID> valueAtPath = FlUniqueId.convertToUniqueId(section.getString(path));
        if (fieldValue.isPresent()) {
            UUID uniqueId = (UUID)fieldValue.get();
            if (valueAtPath.isPresent()) {
                field.setValue(valueAtPath.get());
            } else {
                section.set(path, uniqueId.toString());
            }
        } else {
            valueAtPath.ifPresent(field::setValue);
        }
    }
}

