/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders;

import io.github.portlek.configs.ConfigLoader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.reflection.RefField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlRawField
extends BaseFieldLoader {
    public static final Supplier<FlRawField> INSTANCE = FlRawField::new;
    private static final List<Class> GENERICS = List.of(List.class, Map.class);
    private static final List<Class> RAWS = List.of(String.class, Integer.class, Integer.TYPE, Boolean.class, Boolean.TYPE, Long.TYPE, Long.class, Double.TYPE, Double.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, Float.TYPE, Float.class, Short.TYPE, Short.class);

    @Nullable
    private static Object convertFieldType(@NotNull RefField field, @NotNull Object valueAtPath) {
        Class<?> type = field.getType();
        if (type.isAssignableFrom(valueAtPath.getClass())) {
            return valueAtPath;
        }
        if (type == String.class) {
            return valueAtPath.toString();
        }
        return null;
    }

    private static void loadList(@NotNull Object valueAtPath, @NotNull RefField field) {
        if (!(valueAtPath instanceof List)) {
            return;
        }
        List list = (List)valueAtPath;
        if (list.isEmpty()) {
            try {
                field.setValue(new ArrayList());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return;
        }
        Object listObject = list.get(0);
        Class<?> listObjectClass = listObject.getClass();
        if (!RAWS.contains(listObjectClass) && !GENERICS.contains(listObjectClass)) {
            return;
        }
        try {
            field.setValue(list);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void loadMap(@NotNull Object valueAtPath, @NotNull RefField field) {
        if (!(valueAtPath instanceof Map)) {
            return;
        }
        Map map = (Map)valueAtPath;
        if (map.isEmpty()) {
            try {
                field.setValue(new HashMap());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return;
        }
        Object mapObject = map.entrySet().toArray()[0];
        Class<?> mapObjectClass = mapObject.getClass();
        if (!RAWS.contains(mapObjectClass) && !GENERICS.contains(mapObjectClass)) {
            return;
        }
        try {
            field.setValue(map);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public boolean canLoad(@NotNull ConfigLoader loader, @NotNull RefField field) {
        return RAWS.contains(field.getType()) || GENERICS.contains(field.getType());
    }

    @Override
    public void onLoad(@NotNull ConfigLoader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        Optional<Object> fieldValue = field.getValue();
        ConfigurationSection section = this.getSection(loader);
        Object valueAtPath = section.get(path);
        Class<?> fieldType = field.getType();
        if (fieldValue.isPresent()) {
            if (valueAtPath != null) {
                if (GENERICS.contains(fieldType)) {
                    FlRawField.loadList(valueAtPath, field);
                    FlRawField.loadMap(valueAtPath, field);
                } else {
                    Object converted = FlRawField.convertFieldType(field, valueAtPath);
                    if (converted == null) {
                        section.set(path, fieldValue.get());
                    } else {
                        field.setValue(fieldType.cast(converted));
                    }
                }
            } else {
                section.set(path, fieldValue.get());
            }
        } else if (valueAtPath != null) {
            if (GENERICS.contains(fieldType)) {
                FlRawField.loadList(valueAtPath, field);
                FlRawField.loadMap(valueAtPath, field);
            } else {
                field.setValue(fieldType.cast(valueAtPath));
            }
        }
    }
}

