/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.loaders;

import io.github.portlek.bukkititembuilder.util.ItemStackUtil;
import io.github.portlek.configs.ConfigLoader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.reflection.RefField;
import java.util.Optional;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class FlItemStack
extends BaseFieldLoader {
    public static final Supplier<FlItemStack> INSTANCE = FlItemStack::new;

    @Override
    public boolean canLoad(@NotNull ConfigLoader loader, @NotNull RefField field) {
        return ItemStack.class == field.getType();
    }

    @Override
    public void onLoad(@NotNull ConfigLoader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        Optional<Object> fieldValue = field.getValue();
        ConfigurationSection currentSection = this.getSection(loader);
        ConfigurationSection section = currentSection.getConfigurationSection(path);
        if (section == null) {
            section = currentSection.createSection(path);
        }
        Optional<ItemStack> valueAtPath = ItemStackUtil.from(section.getMapValues(false));
        if (fieldValue.isPresent()) {
            ItemStack itemStack = (ItemStack)fieldValue.get();
            if (valueAtPath.isPresent()) {
                field.setValue(valueAtPath.get());
            } else {
                section.set(path, ItemStackUtil.to(itemStack));
            }
        } else {
            valueAtPath.ifPresent(field::setValue);
        }
    }
}

