/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.replaceable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class RpBase<S extends RpBase<S, X>, X> {
    @NotNull
    private final Collection<UnaryOperator<X>> maps = new ArrayList<UnaryOperator<X>>();
    @NotNull
    private final Collection<String> regex = new ArrayList<String>();
    @NotNull
    private final Map<String, Supplier<String>> replaces = new HashMap<String, Supplier<String>>();
    @NotNull
    private final X value;

    @SafeVarargs
    @NotNull
    public final X build(Map.Entry<String, Supplier<String>> ... entries) {
        return this.build(Arrays.asList(entries));
    }

    @NotNull
    public final X build(@NotNull Collection<Map.Entry<String, Supplier<String>>> entries) {
        return this.build(entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @NotNull
    public final X build(@NotNull Map.Entry<String, Supplier<String>> entry) {
        return this.build(Collections.singletonList(entry));
    }

    @NotNull
    public final X build(@NotNull String regex, @NotNull Supplier<String> replace) {
        return this.build(Map.entry(regex, replace));
    }

    @NotNull
    public final X build(@NotNull Map<String, Supplier<String>> replaces) {
        AtomicReference value = new AtomicReference(this.value);
        this.maps.stream().map((? super T operator) -> operator.apply(value.get())).forEach(value::set);
        this.replaces.forEach((regex, supplier) -> value.set(this.replace((X)value.get(), (CharSequence)regex, (CharSequence)supplier.get())));
        this.regex.stream().filter(replaces::containsKey).forEach(regex -> value.set(this.replace((X)value.get(), (CharSequence)regex, (CharSequence)((Supplier)replaces.get(regex)).get())));
        return value.get();
    }

    @NotNull
    public final <Y> Y buildMap(@NotNull Function<X, Y> function, @NotNull Map<String, Supplier<String>> replaces) {
        return function.apply(this.build(replaces));
    }

    @SafeVarargs
    @NotNull
    public final <Y> Y buildMap(@NotNull Function<X, Y> function, Map.Entry<String, Supplier<String>> ... replaces) {
        return function.apply(this.build(replaces));
    }

    @NotNull
    public final <Y> Y buildMap(@NotNull Function<X, Y> function) {
        return function.apply(this.build(new Map.Entry[0]));
    }

    public final int hashCode() {
        return Objects.hash(this.maps, this.regex, this.replaces, this.value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !RpBase.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        RpBase rpBase = (RpBase)obj;
        return this.maps.equals(rpBase.maps) && this.regex.equals(rpBase.regex) && this.replaces.equals(rpBase.replaces) && this.value.equals(rpBase.value);
    }

    @NotNull
    public final S map(@NotNull Collection<UnaryOperator<X>> map) {
        this.maps.addAll(map);
        return this.self();
    }

    @SafeVarargs
    @NotNull
    public final S map(UnaryOperator<X> ... maps) {
        return this.map(List.of(maps));
    }

    @NotNull
    public final S regex(@NotNull Collection<String> regex) {
        this.regex.addAll(regex);
        return this.self();
    }

    @NotNull
    public final S regex(String ... regex) {
        return this.regex(Arrays.asList(regex));
    }

    @NotNull
    public final S replace(@NotNull Map<String, Supplier<String>> replaces) {
        this.replaces.putAll(replaces);
        return this.self();
    }

    @SafeVarargs
    @NotNull
    public final S replace(Map.Entry<String, Supplier<String>> ... replaces) {
        Arrays.stream(replaces).forEach(entry -> this.replaces.put((String)entry.getKey(), (Supplier)entry.getValue()));
        return this.self();
    }

    @NotNull
    public final S replace(@NotNull String regex, @NotNull Supplier<String> replace) {
        return this.replace(Collections.singletonMap(regex, replace));
    }

    @NotNull
    public final S value(@NotNull X value) {
        return ((RpBase)((RpBase)((RpBase)this.newSelf(value).get()).regex(this.getRegex())).replace(this.getReplaces())).map(this.getMaps());
    }

    @NotNull
    protected abstract Supplier<S> newSelf(@NotNull X var1);

    @NotNull
    protected abstract X replace(@NotNull X var1, @NotNull CharSequence var2, @NotNull CharSequence var3);

    protected abstract S self();

    public RpBase(@NotNull X value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    public String toString() {
        return "RpBase(maps=" + this.getMaps() + ", regex=" + this.getRegex() + ", replaces=" + this.getReplaces() + ", value=" + this.getValue() + ")";
    }

    @NotNull
    public Collection<UnaryOperator<X>> getMaps() {
        return this.maps;
    }

    @NotNull
    public Collection<String> getRegex() {
        return this.regex;
    }

    @NotNull
    public Map<String, Supplier<String>> getReplaces() {
        return this.replaces;
    }

    @NotNull
    public X getValue() {
        return this.value;
    }
}

