/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders;

import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.configs.loaders.DataSerializer;
import io.github.portlek.configs.loaders.SectionSerializer;
import io.github.portlek.reflection.RefField;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class GenericFieldLoader<R, F>
extends BaseFieldLoader
implements SectionSerializer<R, F> {
    @NotNull
    private final Class<F> finalClass;

    @Override
    public boolean canLoad(@NotNull Loader loader, @NotNull RefField field) {
        return this.finalClass.isAssignableFrom(field.getType());
    }

    @Override
    public final void onLoad(@NotNull Loader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        Optional<Object> fieldValueOptional = field.getValue().filter(o -> this.finalClass.isAssignableFrom(o.getClass())).map(this.finalClass::cast);
        ConfigurationSection section = this.prepareSection(this.getSection(loader), path);
        Optional<Object> finalValue0 = this.toFinal(section, fieldValueOptional.orElse(null));
        Optional<Object> valueAtPath = finalValue0.isPresent() ? finalValue0 : this.toConfigObject(section, path).flatMap(r -> this.toFinal(r, fieldValueOptional.orElse(null)));
        if (fieldValueOptional.isPresent()) {
            if (valueAtPath.isPresent()) {
                field.setValue(valueAtPath.get());
            } else {
                Object fieldValue = fieldValueOptional.get();
                if (fieldValue instanceof DataSerializer) {
                    this.toRaw(section, (DataSerializer)fieldValue);
                } else {
                    this.toRaw(fieldValue).ifPresent(r -> section.set(path, r));
                }
            }
        } else {
            valueAtPath.ifPresent(field::setValue);
        }
    }

    @NotNull
    protected ConfigurationSection prepareSection(@NotNull ConfigurationSection currentSection, @NotNull String path) {
        return currentSection;
    }

    protected GenericFieldLoader(@NotNull Class<F> finalClass) {
        if (finalClass == null) {
            throw new NullPointerException("finalClass is marked non-null but is null");
        }
        this.finalClass = finalClass;
    }
}

