/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders;

import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.configs.loaders.DataSerializer;
import io.github.portlek.configs.loaders.SectionSerializer;
import io.github.portlek.reflection.RefField;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class GenericFieldLoader<R, F>
extends BaseFieldLoader
implements SectionSerializer<R, F> {
    @NotNull
    private final Class<F> persistentClass;

    protected GenericFieldLoader() {
        try {
            this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canLoad(@NotNull Loader loader, @NotNull RefField field) {
        return this.persistentClass.isAssignableFrom(field.getType());
    }

    @Override
    public final void onLoad(@NotNull Loader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        Optional<Object> fieldValueOptional = field.getValue().filter(o -> this.persistentClass.isAssignableFrom(o.getClass())).map(this.persistentClass::cast);
        ConfigurationSection section = this.prepareSection(this.getSection(loader), path);
        Optional<Object> finalValue0 = this.toFinal(section, fieldValueOptional.orElse(null));
        Optional<Object> valueAtPath = finalValue0.isPresent() ? finalValue0 : this.toConfigObject(section, path).flatMap(r -> this.toFinal(r, fieldValueOptional.orElse(null)));
        if (fieldValueOptional.isPresent()) {
            if (valueAtPath.isPresent()) {
                field.setValue(valueAtPath.get());
            } else {
                Object fieldValue = fieldValueOptional.get();
                if (fieldValue instanceof DataSerializer) {
                    this.toRaw(section, (DataSerializer)fieldValue);
                } else {
                    Optional rawValue = this.toRaw(fieldValue);
                    if (rawValue.isPresent()) {
                        section.set(path, rawValue);
                    }
                }
            }
        } else {
            valueAtPath.ifPresent(field::setValue);
        }
    }

    @NotNull
    protected ConfigurationSection prepareSection(@NotNull ConfigurationSection currentSection, @NotNull String path) {
        return currentSection;
    }
}

