/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.data;

import com.cryptomorin.xseries.messages.Titles;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.DataSerializer;
import io.github.portlek.replaceable.RpString;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentTitle
implements DataSerializer {
    private final int fadeIn;
    private final int fadeOut;
    private final int stay;
    @Nullable
    private final RpString subTitle;
    @Nullable
    private final RpString title;

    public SentTitle(@Nullable String title, @Nullable String subTitle, int fadeIn, int stay, int fadeOut) {
        this(title == null ? null : RpString.from(title), subTitle == null ? null : RpString.from(subTitle), fadeIn, stay, fadeOut);
    }

    public SentTitle(@Nullable RpString title, @Nullable RpString subTitle, int fadeIn, int stay, int fadeOut) {
        this.title = title;
        this.subTitle = subTitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    @NotNull
    public static Optional<SentTitle> deserialize(@NotNull ConfigurationSection section, @Nullable SentTitle fieldValue) {
        RpString fieldTitle;
        String title = section.getString("title");
        String subTitle = section.getString("sub-title");
        if (title == null && subTitle == null) {
            return Optional.empty();
        }
        int fadeIn = section.getInt("fade-in", 20);
        int stay = section.getInt("stay", 20);
        int fadeOut = section.getInt("fade-out", 20);
        if (fieldValue == null || fieldValue.title == null) {
            fieldTitle = title == null ? null : RpString.from(title);
        } else {
            RpString rpString = fieldTitle = title == null ? null : (RpString)fieldValue.title.value(title);
        }
        RpString fieldSubTitle = fieldValue == null || fieldValue.subTitle == null ? (subTitle == null ? null : RpString.from(subTitle)) : (subTitle == null ? null : (RpString)fieldValue.subTitle.value(subTitle));
        return Optional.of(new SentTitle(fieldTitle, fieldSubTitle, fadeIn, stay, fadeOut));
    }

    @SafeVarargs
    public final void send(@NotNull Player player, Map.Entry<String, Supplier<String>> ... entries) {
        Titles.sendTitle(player, this.fadeIn, this.stay, this.fadeOut, this.title == null ? null : (String)this.title.build(entries), this.subTitle == null ? null : (String)this.subTitle.build(entries));
    }

    @SafeVarargs
    public final void send(@NotNull Player player, @NotNull UnaryOperator<String> title, @NotNull UnaryOperator<String> subTitle, Map.Entry<String, Supplier<String>> ... entries) {
        Titles.sendTitle(player, this.fadeIn, this.stay, this.fadeOut, this.title == null ? null : (String)title.apply((String)this.title.build(entries)), this.subTitle == null ? null : (String)subTitle.apply((String)this.subTitle.build(entries)));
    }

    @Override
    public void serialize(@NotNull ConfigurationSection section) {
        section.set("title", this.title);
        section.set("sub-title", this.subTitle);
        section.set("fade-in", this.fadeIn);
        section.set("stay", this.stay);
        section.set("fade-out", this.fadeOut);
    }
}

