/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.Ignore;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.reflection.RefField;
import io.github.portlek.reflection.clazz.ClassOf;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FieldLoader {
    @NotNull
    public static List<FieldLoader> createLoaders(@NotNull ConfigHolder parentHolder, @NotNull List<Supplier<? extends FieldLoader>> suppliers, @Nullable RefField parentField, @Nullable ConfigurationSection section) {
        return suppliers.stream().map(Supplier::get).peek(fieldLoader -> {
            fieldLoader.setParentHolder(parentHolder);
            if (section != null) {
                fieldLoader.setSection(section);
            }
            if (parentField != null) {
                fieldLoader.setParentField(parentField);
            }
        }).collect(Collectors.toList());
    }

    public static void load(@NotNull Loader loader, @NotNull ConfigHolder holder) {
        FieldLoader.load(loader, holder, loader.getLoaders(), null, null);
    }

    public static void load(@NotNull Loader loader, @NotNull ConfigHolder holder, @NotNull List<Supplier<? extends FieldLoader>> loaders) {
        FieldLoader.load(loader, holder, loaders, null, null);
    }

    public static void load(@NotNull Loader loader, @NotNull ConfigHolder holder, @Nullable RefField parentField, @Nullable ConfigurationSection section) {
        FieldLoader.load(loader, holder, loader.getLoaders(), parentField, section);
    }

    public static void load(@NotNull Loader loader, @NotNull ConfigHolder holder, @NotNull List<Supplier<? extends FieldLoader>> suppliers, @Nullable RefField parentField, @Nullable ConfigurationSection section) {
        List<FieldLoader> loaders = FieldLoader.createLoaders(holder, suppliers, parentField, section);
        new ClassOf<ConfigHolder>(holder).getDeclaredFields().forEach(field -> loaders.stream().filter(fieldLoader -> !field.hasAnnotation(Ignore.class)).filter(fieldLoader -> fieldLoader.canLoad(loader, (RefField)field)).findFirst().ifPresent(fieldLoader -> fieldLoader.onLoad(loader, (RefField)field)));
    }

    public boolean canLoad(@NotNull Loader var1, @NotNull RefField var2);

    @Nullable
    public RefField getParentField();

    public void setParentField(@NotNull RefField var1);

    @Nullable
    public ConfigHolder getParentHolder();

    public void setParentHolder(@NotNull ConfigHolder var1);

    @Nullable
    public ConfigurationSection getSection();

    public void setSection(@NotNull ConfigurationSection var1);

    public void onLoad(@NotNull Loader var1, @NotNull RefField var2);
}

