/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkitversion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class BukkitVersion {
    @NotNull
    private static final Pattern PATTERN = Pattern.compile("v?(?<major>[0-9]+)[._](?<minor>[0-9]+)(?:[._]R(?<micro>[0-9]+))?(?<sub>.*)");
    @NotNull
    private final String version;

    public BukkitVersion(@NotNull String version) {
        this.version = version;
    }

    public BukkitVersion() {
        this(Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1));
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public int major() {
        return this.get("major");
    }

    public int minor() {
        return this.get("minor");
    }

    public int micro() {
        return this.get("micro");
    }

    private int get(@NotNull String key) {
        Matcher matcher = PATTERN.matcher(this.version);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(key));
        }
        return 0;
    }
}

