/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.loaders;

import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.bukkit.data.SentTitle;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.reflection.RefField;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class FlTitle
extends BaseFieldLoader {
    public static final Supplier<FlTitle> INSTANCE = FlTitle::new;

    @Override
    public boolean canLoad(@NotNull Loader loader, @NotNull RefField field) {
        return SentTitle.class == field.getType();
    }

    @Override
    public void onLoad(@NotNull Loader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        Optional<Object> fieldValue = field.getValue();
        ConfigurationSection currentSection = this.getSection(loader);
        ConfigurationSection section = currentSection.getConfigurationSection(path);
        if (section == null) {
            section = currentSection.createSection(path);
        }
        Optional<SentTitle> valueAtPath = SentTitle.deserialize(section);
        if (fieldValue.isPresent()) {
            SentTitle sentTitle = (SentTitle)fieldValue.get();
            if (valueAtPath.isPresent()) {
                field.setValue(valueAtPath.get());
            } else {
                SentTitle.serialize(sentTitle, section);
            }
        } else {
            valueAtPath.ifPresent(field::setValue);
        }
    }
}

