/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.data;

import com.cryptomorin.xseries.messages.Titles;
import io.github.portlek.configs.configuration.ConfigurationSection;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentTitle {
    private final int fadeIn;
    private final int fadeOut;
    private final int stay;
    @Nullable
    private final String subTitle;
    @Nullable
    private final String title;

    public SentTitle(@Nullable String title, @Nullable String subTitle, int fadeIn, int stay, int fadeOut) {
        this.title = title;
        this.subTitle = subTitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    @NotNull
    public static Optional<SentTitle> deserialize(@NotNull ConfigurationSection section) {
        String title = section.getString("title");
        String subTitle = section.getString("sub-title");
        if (title == null && subTitle == null) {
            return Optional.empty();
        }
        int fadeIn = section.getInt("fade-in", 20);
        int stay = section.getInt("stay", 20);
        int fadeOut = section.getInt("fade-out", 20);
        return Optional.of(new SentTitle(title, subTitle, fadeIn, stay, fadeOut));
    }

    public static void serialize(@NotNull SentTitle sentTitle, @NotNull ConfigurationSection section) {
        section.set("title", sentTitle.title);
        section.set("sub-title", sentTitle.subTitle);
        section.set("fade-in", sentTitle.fadeIn);
        section.set("stay", sentTitle.stay);
        section.set("fade-out", sentTitle.fadeOut);
    }

    public void send(@NotNull Player player) {
        Titles.sendTitle(player, this.fadeIn, this.stay, this.fadeOut, this.title, this.subTitle);
    }

    public void send(@NotNull Player player, @NotNull UnaryOperator<String> title, @NotNull UnaryOperator<String> subTitle) {
        Titles.sendTitle(player, this.fadeIn, this.stay, this.fadeOut, (String)title.apply(this.title), (String)subTitle.apply(this.subTitle));
    }
}

