/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders;

import io.github.portlek.configs.ConfigLoader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.reflection.RefField;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlLocale
extends BaseFieldLoader {
    public static final Supplier<FlLocale> INSTANCE = FlLocale::new;

    @NotNull
    private static Optional<Locale> convertToLocale(@Nullable String raw) {
        if (raw == null) {
            return Optional.empty();
        }
        String trim = raw.trim();
        String[] strings = trim.split("_");
        if (trim.contains("_") && strings.length != 2) {
            return Optional.of(Locale.ROOT);
        }
        if (strings.length != 2) {
            return Optional.empty();
        }
        return Optional.of(new Locale(strings[0], strings[1]));
    }

    @Override
    public boolean canLoad(@NotNull ConfigLoader loader, @NotNull RefField field) {
        return Locale.class == field.getType();
    }

    @Override
    public void onLoad(@NotNull ConfigLoader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        Optional<Object> fieldValue = field.getValue();
        ConfigurationSection section = this.getSection(loader);
        Optional<Locale> valueAtPath = FlLocale.convertToLocale(section.getString(path));
        if (fieldValue.isPresent()) {
            Locale locale = (Locale)fieldValue.get();
            if (valueAtPath.isPresent()) {
                field.setValue(valueAtPath.get());
            } else {
                section.set(path, locale.getLanguage() + "_" + locale.getCountry());
            }
        } else {
            valueAtPath.ifPresent(field::setValue);
        }
    }
}

