/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.ConfigLoader;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.reflection.RefField;
import io.github.portlek.reflection.clazz.ClassOf;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FieldLoader {
    @NotNull
    public static List<FieldLoader> createLoaders(@NotNull List<Supplier<? extends FieldLoader>> suppliers, @Nullable RefField parentField, @Nullable ConfigurationSection section) {
        return suppliers.stream().map(Supplier::get).peek(loader -> {
            if (section != null) {
                loader.setSection(section);
            }
            if (parentField != null) {
                loader.setParentField(parentField);
            }
        }).collect(Collectors.toList());
    }

    public static void load(@NotNull ConfigLoader configLoader, @NotNull Class<? extends ConfigHolder> holderClass, @NotNull List<Supplier<? extends FieldLoader>> loaders) {
        FieldLoader.load(configLoader, holderClass, loaders, null, null);
    }

    public static void load(@NotNull ConfigLoader configLoader, @NotNull Class<? extends ConfigHolder> holderClass, @NotNull List<Supplier<? extends FieldLoader>> suppliers, @Nullable RefField parentField, @Nullable ConfigurationSection section) {
        List<FieldLoader> loaders = FieldLoader.createLoaders(suppliers, parentField, section);
        new ClassOf<Class<? extends ConfigHolder>>(holderClass).getDeclaredFields().forEach(field -> loaders.stream().filter(loader -> loader.canLoad(configLoader, (RefField)field)).findFirst().ifPresent(loader -> loader.onLoad(configLoader, (RefField)field)));
    }

    public boolean canLoad(@NotNull ConfigLoader var1, @NotNull RefField var2);

    @Nullable
    public RefField getParentField();

    public void setParentField(@NotNull RefField var1);

    @Nullable
    public ConfigurationSection getSection();

    public void setSection(@NotNull ConfigurationSection var1);

    public void onLoad(@NotNull ConfigLoader var1, @NotNull RefField var2);
}

