/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.ConfigType;
import io.github.portlek.configs.configuration.FileConfiguration;
import io.github.portlek.configs.exceptions.InvalidConfigurationException;
import io.github.portlek.configs.loaders.FieldLoader;
import io.github.portlek.configs.loaders.FlConfigHolder;
import io.github.portlek.configs.loaders.FlConfigLoader;
import io.github.portlek.configs.loaders.FlConfiguration;
import io.github.portlek.configs.loaders.FlConfigurationSection;
import io.github.portlek.configs.loaders.FlFile;
import io.github.portlek.configs.loaders.FlLocale;
import io.github.portlek.configs.loaders.FlRawField;
import io.github.portlek.configs.loaders.FlUniqueId;
import io.github.portlek.configs.util.Validate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigLoader {
    @NotNull
    public final Executor asyncExecutor;
    @Nullable
    private final Class<? extends ConfigHolder> configHolder;
    @NotNull
    private final ConfigType configType;
    @NotNull
    private final String fileName;
    @NotNull
    private final Path folderPath;
    @NotNull
    private final List<Supplier<? extends FieldLoader>> loaders;
    @Nullable
    private FileConfiguration configuration;
    @Nullable
    private File file;

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public FileConfiguration getConfiguration() {
        return Objects.requireNonNull(this.configuration, "Use #load() method before save the config!");
    }

    @NotNull
    public File getFile() {
        return Objects.requireNonNull(this.file, "Use #load() method before save the config!");
    }

    @NotNull
    public CompletableFuture<ConfigLoader> load(boolean save, boolean async) {
        Path filePath = this.folderPath.resolve(this.fileName + this.configType.getSuffix());
        this.file = filePath.toFile();
        if (Files.notExists(filePath, new LinkOption[0])) {
            try {
                Files.createFile(filePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!async) {
            this.loadFile();
            this.loadFieldsAndSave(save);
            return CompletableFuture.completedFuture(this);
        }
        return ((CompletableFuture)CompletableFuture.runAsync(this::loadFile, this.asyncExecutor).whenCompleteAsync((unused, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
                return;
            }
            this.loadFieldsAndSave(save);
        }, this.asyncExecutor)).thenApplyAsync(unused -> this, this.asyncExecutor);
    }

    @NotNull
    public ConfigLoader load() {
        return this.load(false);
    }

    @NotNull
    public ConfigLoader load(boolean save) {
        return this.load(save, false).join();
    }

    public void save() throws IOException {
        this.configType.save(this.getFile(), this.getConfiguration());
    }

    private void loadFieldsAndSave(boolean save) {
        if (this.configHolder != null) {
            FieldLoader.load(this, this.configHolder, this.loaders);
        }
        if (save) {
            try {
                this.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void loadFile() {
        Validate.checkNull(this.file, "file", new Object[0]);
        try {
            this.configuration = this.configType.load(this.file);
        }
        catch (InvalidConfigurationException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigLoader(@NotNull Executor asyncExecutor, @Nullable Class<? extends ConfigHolder> configHolder, @NotNull ConfigType configType, @NotNull String fileName, @NotNull Path folderPath, @NotNull List<Supplier<? extends FieldLoader>> loaders) {
        if (asyncExecutor == null) {
            throw new NullPointerException("asyncExecutor is marked non-null but is null");
        }
        if (configType == null) {
            throw new NullPointerException("configType is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (folderPath == null) {
            throw new NullPointerException("folderPath is marked non-null but is null");
        }
        if (loaders == null) {
            throw new NullPointerException("loaders is marked non-null but is null");
        }
        this.asyncExecutor = asyncExecutor;
        this.configHolder = configHolder;
        this.configType = configType;
        this.fileName = fileName;
        this.folderPath = folderPath;
        this.loaders = loaders;
    }

    @NotNull
    public Executor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    @Nullable
    public Class<? extends ConfigHolder> getConfigHolder() {
        return this.configHolder;
    }

    @NotNull
    public ConfigType getConfigType() {
        return this.configType;
    }

    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    public Path getFolderPath() {
        return this.folderPath;
    }

    @NotNull
    public List<Supplier<? extends FieldLoader>> getLoaders() {
        return this.loaders;
    }

    public static final class Builder {
        @NotNull
        private final List<Supplier<? extends FieldLoader>> loaders = new ArrayList<Supplier<? extends FieldLoader>>(){
            {
                this.add(FlConfigurationSection.INSTANCE);
                this.add(FlConfiguration.INSTANCE);
                this.add(FlConfigHolder.INSTANCE);
                this.add(FlConfigLoader.INSTANCE);
                this.add(FlRawField.INSTANCE);
                this.add(FlUniqueId.INSTANCE);
                this.add(FlLocale.INSTANCE);
                this.add(FlFile.INSTANCE);
            }
        };
        @NotNull
        private Executor asyncExecutor = Executors.newSingleThreadExecutor();
        @Nullable
        private Class<? extends ConfigHolder> configHolder;
        @Nullable
        private ConfigType configType;
        @Nullable
        private String fileName;
        @Nullable
        private Path folderPath;

        private Builder() {
        }

        @SafeVarargs
        @NotNull
        public final Builder addLoaders(Supplier<? extends FieldLoader> ... loaders) {
            this.loaders.addAll(Arrays.asList(loaders));
            return this;
        }

        @NotNull
        public ConfigLoader build() {
            Validate.checkNull(this.configType, "Use #setConfigType(ConfigType) method to set config type!", new Object[0]);
            Validate.checkNull(this.fileName, "Use #setFileName(String) method to set file name!", new Object[0]);
            Validate.checkNull(this.folderPath, "Use #setFolderPath(Path) method to set file path!", new Object[0]);
            return new ConfigLoader(this.asyncExecutor, this.configHolder, this.configType, this.fileName, this.folderPath, this.loaders);
        }

        @NotNull
        public Builder setAsyncExecutor(@NotNull Executor asyncExecutor) {
            this.asyncExecutor = asyncExecutor;
            return this;
        }

        @NotNull
        public Builder setConfigHolder(@NotNull Class<? extends ConfigHolder> configHolder) {
            this.configHolder = configHolder;
            return this;
        }

        @NotNull
        public Builder setConfigType(@NotNull ConfigType configType) {
            this.configType = configType;
            return this;
        }

        @NotNull
        public Builder setFileName(@NotNull String fileName) {
            this.fileName = fileName;
            return this;
        }

        @NotNull
        public Builder setFolderPath(@NotNull File file) {
            return this.setFolderPath(file.toPath());
        }

        @NotNull
        public Builder setFolderPath(@NotNull Path folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        @NotNull
        public List<Supplier<? extends FieldLoader>> getLoaders() {
            return this.loaders;
        }

        @NotNull
        public Executor getAsyncExecutor() {
            return this.asyncExecutor;
        }

        @Nullable
        public Class<? extends ConfigHolder> getConfigHolder() {
            return this.configHolder;
        }

        @Nullable
        public ConfigType getConfigType() {
            return this.configType;
        }

        @Nullable
        public String getFileName() {
            return this.fileName;
        }

        @Nullable
        public Path getFolderPath() {
            return this.folderPath;
        }
    }
}

