/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.replaceable;

import io.github.portlek.mapentry.MapEntry;
import io.github.portlek.replaceable.rp.RpList;
import io.github.portlek.replaceable.rp.RpString;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface Replaceable<S extends Replaceable<S, X>, X> {
    @NotNull
    public static RpString from(@NotNull StringBuilder builder) {
        return Replaceable.from(builder.toString());
    }

    @NotNull
    public static RpList from(String ... texts) {
        return Replaceable.from(Arrays.asList(texts));
    }

    @NotNull
    public static RpList from(@NotNull List<String> list) {
        return new RpList(list);
    }

    @NotNull
    public static RpString from(@NotNull String text) {
        return new RpString(text);
    }

    @NotNull
    default public S value(@NotNull X value) {
        return ((Replaceable)this.newSelf(value).get()).replaces(this.getRegex()).replace(this.getReplaces()).map(this.getMaps());
    }

    @NotNull
    default public <Y> Y buildMap(@NotNull Function<X, Y> function, @NotNull Map<String, Supplier<String>> replaces) {
        return function.apply(this.build(replaces));
    }

    @NotNull
    default public <Y> Y buildMap(@NotNull Function<X, Y> function) {
        return function.apply(this.build());
    }

    @NotNull
    default public X build() {
        return this.build(Collections.emptyMap());
    }

    @NotNull
    default public X build(@NotNull Map<String, Supplier<String>> replaces) {
        AtomicReference value = new AtomicReference(this.getValue());
        this.getReplaces().forEach((s, replace) -> this.replace(value, (CharSequence)s, (CharSequence)replace.get()));
        this.getRegex().forEach(r -> Optional.ofNullable(replaces.get(r)).ifPresent(supplier -> this.replace(value, (CharSequence)r, (CharSequence)supplier.get())));
        this.getMaps().forEach(operator -> value.set(operator.apply(value.get())));
        return value.get();
    }

    @NotNull
    default public X build(@NotNull Collection<Map.Entry<String, Supplier<String>>> entries) {
        return this.build(entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @NotNull
    default public X build(@NotNull Map.Entry<String, Supplier<String>> entry) {
        return this.build(Collections.singletonList(entry));
    }

    @NotNull
    default public X build(Map.Entry<String, Supplier<String>> ... entries) {
        return this.build(Arrays.asList(entries));
    }

    @NotNull
    default public X build(@NotNull String regex, @NotNull Supplier<String> replace) {
        return this.build(MapEntry.from(regex, replace));
    }

    @NotNull
    default public S map(@NotNull UnaryOperator<X> map) {
        return this.map(Collections.singletonList(map));
    }

    @NotNull
    default public S replaces(String ... regex) {
        return this.replaces(Arrays.asList(regex));
    }

    @NotNull
    default public S replace(@NotNull String regex, @NotNull Supplier<String> replace) {
        return this.replace(Collections.singletonMap(regex, replace));
    }

    @NotNull
    public S self();

    @NotNull
    public Supplier<S> newSelf(@NotNull X var1);

    public void replace(@NotNull AtomicReference<X> var1, @NotNull CharSequence var2, @NotNull CharSequence var3);

    public S replace(@NotNull Map<String, Supplier<String>> var1);

    @NotNull
    public S replace(Map.Entry<String, Supplier<String>> ... var1);

    @NotNull
    public S replaces(@NotNull Collection<String> var1);

    @NotNull
    public S map(@NotNull Collection<UnaryOperator<X>> var1);

    @NotNull
    public X getValue();

    @NotNull
    public Collection<String> getRegex();

    @NotNull
    public Map<String, Supplier<String>> getReplaces();

    @NotNull
    public Collection<UnaryOperator<X>> getMaps();
}

