/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.ReflectionUtils;
import com.cryptomorin.xseries.SkullCacheListener;
import com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullUtils {
    protected static final MethodHandle GAME_PROFILE;
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    private static final boolean SUPPORTS_UUID;
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";

    @Nonnull
    public static ItemStack getSkull(@Nonnull UUID id) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        } else {
            meta.setOwner(id.toString());
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @Nonnull
    public static SkullMeta applyCachedSkin(@Nonnull ItemMeta head, @Nonnull UUID identifier) {
        String base64 = SkullCacheListener.CACHE.get(identifier);
        SkullMeta meta = (SkullMeta)head;
        return SkullUtils.getSkullByValue(meta, base64);
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull OfflinePlayer identifier) {
        SkullMeta meta = (SkullMeta)head;
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(identifier);
        } else {
            meta.setOwner(identifier.getName());
        }
        return meta;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull UUID identifier) {
        return SkullUtils.applySkin(head, Bukkit.getOfflinePlayer((UUID)identifier));
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull String identifier) {
        SkullMeta meta = (SkullMeta)head;
        if (SkullUtils.isUsername(identifier)) {
            return SkullUtils.applySkin(head, Bukkit.getOfflinePlayer((String)identifier));
        }
        if (identifier.contains("textures.minecraft.net")) {
            return SkullUtils.getValueFromTextures(meta, identifier);
        }
        if (identifier.length() > 100 && SkullUtils.isBase64(identifier)) {
            return SkullUtils.getSkullByValue(meta, identifier);
        }
        return SkullUtils.getTexturesFromUrlValue(meta, identifier);
    }

    @Nonnull
    private static SkullMeta getSkullByValue(@Nonnull SkullMeta head, @Nonnull String value) {
        Validate.notEmpty((String)value, (String)"Skull value cannot be null or empty");
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
        try {
            GAME_PROFILE.invoke(head, profile);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return head;
    }

    @Nonnull
    private static SkullMeta getValueFromTextures(@Nonnull SkullMeta head, @Nonnull String url) {
        return SkullUtils.getSkullByValue(head, SkullUtils.encodeBase64(VALUE_PROPERTY + url + "\"}}}"));
    }

    @Nonnull
    private static SkullMeta getTexturesFromUrlValue(@Nonnull SkullMeta head, @Nonnull String urlValue) {
        return SkullUtils.getValueFromTextures(head, TEXTURES + urlValue);
    }

    @Nonnull
    private static String encodeBase64(@Nonnull String str) {
        return Base64.getEncoder().encodeToString(str.getBytes());
    }

    private static boolean isBase64(@Nonnull String base64) {
        Base64.Decoder decoder = Base64.getDecoder();
        try {
            decoder.decode(base64);
            return true;
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    @Nullable
    public static String getSkinValue(@Nonnull ItemMeta skull) {
        Objects.requireNonNull(skull, "Skull ItemStack cannot be null");
        SkullMeta meta = (SkullMeta)skull;
        GameProfile profile = null;
        try {
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profile = (GameProfile)profileField.get(meta);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace();
        }
        if (profile != null && !profile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : profile.getProperties().get((Object)"textures")) {
                if (property.getValue().isEmpty()) continue;
                return property.getValue();
            }
        }
        return null;
    }

    private static boolean isUsername(@Nonnull String name) {
        int len = name.length();
        if (len < 3 || len > 16) {
            return false;
        }
        UnmodifiableIterator unmodifiableIterator = Lists.charactersOf((String)name).iterator();
        while (unmodifiableIterator.hasNext()) {
            char ch = ((Character)unmodifiableIterator.next()).charValue();
            if (ch == '_' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        SUPPORTS_UUID = XMaterial.supports(12);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle gameProfile = null;
        try {
            Class<?> craftSkull = ReflectionUtils.getCraftClass("inventory.CraftMetaSkull");
            Field profileField = craftSkull.getDeclaredField("profile");
            profileField.setAccessible(true);
            gameProfile = lookup.unreflectSetter(profileField);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        GAME_PROFILE = gameProfile;
    }
}

