/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.util;

import com.cryptomorin.xseries.messages.Titles;
import io.github.portlek.mapentry.MapEntry;
import io.github.portlek.replaceable.rp.RpString;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class SentTitle {
    @NotNull
    private final RpString title;
    @NotNull
    private final RpString subTitle;
    private final int fadeIn;
    private final int showTime;
    private final int fadeOut;

    @NotNull
    public void buildAndSend(@NotNull Player player, @NotNull String regex, @NotNull Supplier<String> replace) {
        this.buildAndSend(player, MapEntry.from(regex, replace));
    }

    @SafeVarargs
    @NotNull
    public final void buildAndSend(@NotNull Player player, Map.Entry<String, Supplier<String>> ... entries) {
        this.buildAndSend(player, Arrays.asList(entries));
    }

    @NotNull
    public void buildAndSend(@NotNull Player player, final @NotNull Iterable<Map.Entry<String, Supplier<String>>> entries) {
        this.buildAndSend(player, (Map<String, Supplier<String>>)new HashMap<String, Supplier<String>>(){
            {
                entries.forEach((? super T entry) -> {
                    Supplier cfr_ignored_0 = (Supplier)this.put(entry.getKey(), entry.getValue());
                });
            }
        });
    }

    @NotNull
    public void buildAndSend(@NotNull Player player) {
        this.buildAndSend(player, Collections.emptyMap());
    }

    @NotNull
    public void buildAndSend(@NotNull Player player, @NotNull Map<String, Supplier<String>> replaces) {
        this.send(player, (String)this.title.build(replaces), (String)this.subTitle.build(replaces));
    }

    private void send(@NotNull Player player, @NotNull String builttitle, @NotNull String builtsubtitle) {
        Titles.sendTitle(player, this.fadeIn, this.showTime, this.fadeOut, builttitle.isEmpty() ? null : builttitle, builtsubtitle.isEmpty() ? null : builttitle);
    }

    public SentTitle(@NotNull RpString title, @NotNull RpString subTitle, int fadeIn, int showTime, int fadeOut) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (subTitle == null) {
            throw new NullPointerException("subTitle is marked non-null but is null");
        }
        this.title = title;
        this.subTitle = subTitle;
        this.fadeIn = fadeIn;
        this.showTime = showTime;
        this.fadeOut = fadeOut;
    }

    @NotNull
    public RpString getTitle() {
        return this.title;
    }

    @NotNull
    public RpString getSubTitle() {
        return this.subTitle;
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public int getShowTime() {
        return this.showTime;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }
}

