/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.util;

import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public final class Position {
    @NotNull
    private final String worldName;
    private final double x;
    private final double y;
    private final double z;

    public Position(@NotNull Location location) {
        this(Objects.requireNonNull(location.getWorld()).getName(), location.getX(), location.getY(), location.getZ());
    }

    @NotNull
    public Optional<Location> parse() {
        return Optional.ofNullable(Bukkit.getWorld((String)this.worldName)).map(world -> new Location(world, this.x, this.y, this.z));
    }

    public Position(@NotNull String worldName, double x, double y, double z) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

