/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkititembuilder.util;

import com.cryptomorin.xseries.SkullUtils;
import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import io.github.portlek.bukkititembuilder.util.ColorUtil;
import io.github.portlek.bukkitversion.BukkitVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public final class ItemStackUtil {
    private static final String[] MATERIAL_KEYS = new String[]{"material", "mat", "esya", "e\u015fya", "id"};
    private static final String[] AMOUNT_KEYS = new String[]{"amount", "quantity", "miktar"};
    private static final String[] DAMAGE_KEYS = new String[]{"damage", "durability"};
    private static final String[] DATA_KEYS = new String[]{"data"};
    private static final String[] SKULL_TEXTURE_KEYS = new String[]{"skull", "skull-texture", "texture", "skin"};
    private static final String[] DISPLAY_NAME_KEYS = new String[]{"name", "display", "display-name", "isim", "ad"};
    private static final String[] LORE_KEYS = new String[]{"lore", "a\u00e7\u0131klama"};
    private static final String[] ENCHANTMENT_KEYS = new String[]{"enchants", "enchantments", "enchant", "enchantment", "b\u00fcy\u00fc", "b\u00fcy\u00fcler"};
    private static final String[] FLAG_KEYS = new String[]{"flags", "flag"};
    private static final int VERSION = new BukkitVersion().minor();

    @NotNull
    public static Map<String, Object> to(@NotNull ItemStack itemStack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String materialKey = MATERIAL_KEYS[0];
        String amountKey = AMOUNT_KEYS[0];
        String damageKey = DAMAGE_KEYS[0];
        String dataKey = DATA_KEYS[0];
        String displayNameKey = DISPLAY_NAME_KEYS[0];
        String loreKey = LORE_KEYS[0];
        String enchantmentKey = ENCHANTMENT_KEYS[0];
        String flagKey = FLAG_KEYS[0];
        map.put(materialKey, itemStack.getType().toString());
        map.put(amountKey, itemStack.getAmount());
        if (itemStack.getDurability() != 0) {
            map.put(damageKey, itemStack.getDurability());
        }
        if (VERSION < 13) {
            Optional.ofNullable(itemStack.getData()).filter(materialData -> materialData.getData() != 0).ifPresent(materialData -> map.put(dataKey, materialData.getData()));
        }
        String skullTextureKey = SKULL_TEXTURE_KEYS[0];
        Optional.ofNullable(itemStack.getItemMeta()).ifPresent(itemMeta -> {
            if (itemMeta instanceof SkullMeta) {
                Optional.ofNullable(SkullUtils.getSkinValue(itemStack)).ifPresent(s -> map.put(skullTextureKey, s));
            }
            if (itemMeta.hasDisplayName()) {
                map.put(displayNameKey, itemMeta.getDisplayName().replace("\u00a7", "&"));
            }
            Optional.ofNullable(itemMeta.getLore()).ifPresent(lore -> map.put(loreKey, lore.stream().map(s -> s.replace("\u00a7", "&")).collect(Collectors.toList())));
            Set flags = itemMeta.getItemFlags();
            if (!flags.isEmpty()) {
                map.put(flagKey, flags.stream().map(Enum::name).collect(Collectors.toList()));
            }
        });
        HashMap enchantments = new HashMap();
        itemStack.getEnchantments().forEach((enchantment, integer) -> enchantments.put(enchantment.getName(), integer));
        if (!enchantments.isEmpty()) {
            map.put(enchantmentKey, enchantments);
        }
        return map;
    }

    @NotNull
    public static Optional<ItemStack> from(@NotNull Map<String, Object> map) {
        ItemStack itemStack;
        Material material;
        Optional<String> materialStringOptional = ItemStackUtil.getOrDefault(map, String.class, MATERIAL_KEYS);
        if (!materialStringOptional.isPresent()) {
            return Optional.empty();
        }
        String materialString = materialStringOptional.get();
        if (VERSION > 7) {
            Optional<XMaterial> xmaterialoptional = XMaterial.matchXMaterial(materialString);
            if (!xmaterialoptional.isPresent()) {
                return Optional.empty();
            }
            Optional<Material> mtrloptnl = Optional.ofNullable(xmaterialoptional.get().parseMaterial());
            if (!mtrloptnl.isPresent()) {
                return Optional.empty();
            }
            material = mtrloptnl.get();
        } else {
            material = Material.getMaterial((String)materialString);
        }
        if (material == null) {
            return Optional.empty();
        }
        Integer amount = ItemStackUtil.getOrDefault(map, Number.class, AMOUNT_KEYS).map(Number::intValue).orElse(1);
        if (VERSION < 13) {
            itemStack = new ItemStack(material, amount.intValue());
            ItemStackUtil.getOrDefault(map, Number.class, DAMAGE_KEYS).map(Number::shortValue).ifPresent(arg_0 -> ((ItemStack)itemStack).setDurability(arg_0));
            ItemStackUtil.getOrDefault(map, Number.class, DATA_KEYS).map(Number::byteValue).map(arg_0 -> ((Material)material).getNewData(arg_0)).ifPresent(arg_0 -> ((ItemStack)itemStack).setData(arg_0));
        } else {
            itemStack = new ItemStack(material, amount.intValue());
            ItemStackUtil.getOrDefault(map, Number.class, DAMAGE_KEYS).ifPresent(integer -> itemStack.setDurability(integer.shortValue()));
        }
        Optional.ofNullable(itemStack.getItemMeta()).ifPresent(itemMeta -> {
            if (itemMeta instanceof SkullMeta) {
                ItemStackUtil.getOrDefault(map, String.class, SKULL_TEXTURE_KEYS).ifPresent(s -> SkullUtils.applySkin(itemMeta, s));
            }
            ItemStackUtil.getOrDefault(map, String.class, DISPLAY_NAME_KEYS).ifPresent(s -> itemMeta.setDisplayName(ColorUtil.colored(s)));
            ItemStackUtil.getOrDefault(map, Collection.class, LORE_KEYS).map(list -> new ArrayList(list)).map(ColorUtil::colored).ifPresent(arg_0 -> ((ItemMeta)itemMeta).setLore(arg_0));
            ItemStackUtil.getOrDefault(map, Map.class, ENCHANTMENT_KEYS).map(mp -> mp).ifPresent(mp -> mp.forEach((key, value) -> XEnchantment.matchXEnchantment(String.valueOf(key)).flatMap(xEnchantment -> Optional.ofNullable(xEnchantment.parseEnchantment())).ifPresent(enchantment -> itemMeta.addEnchant(enchantment, value.intValue(), true))));
            ItemStackUtil.getOrDefault(map, Collection.class, FLAG_KEYS).map(flags -> new ArrayList(flags)).ifPresent(flags -> flags.stream().map(ItemFlag::valueOf).forEach(xva$0 -> itemMeta.addItemFlags(new ItemFlag[]{xva$0})));
            itemStack.setItemMeta(itemMeta);
        });
        return Optional.of(itemStack);
    }

    @NotNull
    private static <T> Optional<T> getOrDefault(@NotNull Map<String, Object> map, @NotNull Class<T> tClass, String ... keys) {
        return ItemStackUtil.getOrDefault(map, tClass, new LinkedList<String>(Arrays.asList(keys)));
    }

    @NotNull
    private static <T> Optional<T> getOrDefault(@NotNull Map<String, Object> map, @NotNull Class<T> tClass, @NotNull LinkedList<String> keys) {
        String key = keys.pollFirst();
        if (key == null) {
            return Optional.empty();
        }
        if (!map.containsKey(key)) {
            return ItemStackUtil.getOrDefault(map, tClass, keys);
        }
        Object object = map.get(key);
        if (tClass.isAssignableFrom(object.getClass())) {
            return Optional.of(object);
        }
        return ItemStackUtil.getOrDefault(map, tClass, keys);
    }

    private ItemStackUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

