/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.provided;

import com.cryptomorin.xseries.XSound;
import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.Provided;
import io.github.portlek.configs.bukkit.util.PlayableSound;
import io.github.portlek.configs.util.GeneralUtilities;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Sound;
import org.jetbrains.annotations.NotNull;

public final class BukkitSoundProvider
implements Provided<PlayableSound> {
    public void set(@NotNull PlayableSound sound, @NotNull CfgSection section, @NotNull String path) {
        String fnlpath = GeneralUtilities.putDot((String)path);
        section.set(fnlpath + "sound", (Object)sound.getSound().name());
        section.set(fnlpath + "volume", (Object)sound.getVolume());
        section.set(fnlpath + "pitch", (Object)sound.getPitch());
    }

    @NotNull
    public Optional<PlayableSound> get(@NotNull CfgSection section, @NotNull String path) {
        String fnlpath = GeneralUtilities.putDot((String)path);
        Optional volume = section.getDouble(fnlpath + "volume");
        Optional pitch = section.getDouble(fnlpath + "pitch");
        Optional<Sound> sound = section.getString(fnlpath + "sound").flatMap(XSound::matchXSound).map(XSound::parseSound).filter(Objects::nonNull);
        if (!(sound.isPresent() && volume.isPresent() && pitch.isPresent())) {
            return Optional.empty();
        }
        return Optional.of(new PlayableSound(sound.get(), (Double)volume.get(), (Double)pitch.get()));
    }
}

