/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit;

import com.cryptomorin.xseries.XMaterial;
import io.github.portlek.bukkitlocation.LocationUtil;
import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.Provided;
import io.github.portlek.configs.bukkit.provided.BukkitItemStackProvider;
import io.github.portlek.configs.bukkit.provided.BukkitSoundProvider;
import io.github.portlek.configs.bukkit.provided.BukkitTitleProvider;
import io.github.portlek.configs.bukkit.util.PlayableSound;
import io.github.portlek.configs.bukkit.util.SentTitle;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class BukkitExtensions {
    public static void registerExtensions() {
        CfgSection.addProvidedClass(ItemStack.class, (Provided)new BukkitItemStackProvider());
        CfgSection.addProvidedClass(PlayableSound.class, (Provided)new BukkitSoundProvider());
        CfgSection.addProvidedClass(SentTitle.class, (Provided)new BukkitTitleProvider());
        CfgSection.addProvidedGetMethod(Material.class, (section, s) -> section.getString(s).map(XMaterial::matchXMaterial).filter(Optional::isPresent).map(Optional::get).flatMap(xMaterial -> Optional.ofNullable(xMaterial.parseMaterial())));
        CfgSection.addProvidedSetMethod(Material.class, (material, section, path) -> section.set(path, (Object)material.name()));
        CfgSection.addProvidedGetMethod(XMaterial.class, (section, s) -> section.getString(s).flatMap(XMaterial::matchXMaterial));
        CfgSection.addProvidedSetMethod(XMaterial.class, (xMaterial, section, path) -> section.set(path, (Object)xMaterial.name()));
        CfgSection.addProvidedGetMethod(Location.class, (section, s) -> section.getString(s).flatMap(LocationUtil::fromKey));
        CfgSection.addProvidedSetMethod(Location.class, (location, section, path) -> section.set(path, (Object)LocationUtil.toKey(location)));
    }

    private BukkitExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

