/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.bukkit.util;

import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class PlayableSound {
    @NotNull
    private final Sound sound;
    private final Double volume;
    private final Double pitch;

    public void play(@NotNull Player player) {
        this.play(player, player.getLocation());
    }

    public void play(@NotNull Player player, @NotNull Location location) {
        player.playSound(location, this.sound, this.volume.floatValue(), this.pitch.floatValue());
    }

    public PlayableSound(@NotNull Sound sound, Double volume, Double pitch) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    @NotNull
    public Sound getSound() {
        return this.sound;
    }

    public Double getVolume() {
        return this.volume;
    }

    public Double getPitch() {
        return this.pitch;
    }
}

