/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import io.github.portlek.configs.util.GetResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public final class SaveResource {
    @NotNull
    private final String datafolder;
    @NotNull
    private final String path;

    public SaveResource(@NotNull String datafolder, @NotNull String path) {
        this.datafolder = datafolder;
        this.path = path;
    }

    @NotNull
    public File value() {
        File outfile;
        int lastindex;
        if (this.path.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be empty");
        }
        String replace = this.path.replace('\\', '/');
        File outdir = new File(this.datafolder, replace.substring(0, Math.max(lastindex = replace.lastIndexOf(47), 0)));
        if (!outdir.exists()) {
            outdir.getParentFile().mkdirs();
            outdir.mkdirs();
        }
        if (!(outfile = new File(this.datafolder, replace)).exists()) {
            try (FileOutputStream out = new FileOutputStream(outfile);
                 InputStream input = new GetResource(replace).value();){
                int len;
                if (input == null) {
                    throw new IllegalArgumentException("The embedded resource '" + replace + "' cannot be found!");
                }
                byte[] buf = new byte[1024];
                while ((len = input.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        return outfile;
    }
}

