/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.util.ListReplace;
import io.github.portlek.configs.util.MapEntry;
import io.github.portlek.configs.util.Provided;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class Replaceable<X> {
    @NotNull
    private final X value;
    @NotNull
    private final List<String> regex = new ArrayList<String>();
    @NotNull
    private final Map<String, Supplier<String>> replaces = new HashMap<String, Supplier<String>>();
    @NotNull
    private final List<UnaryOperator<X>> maps = new ArrayList<UnaryOperator<X>>();

    private Replaceable(@NotNull X value) {
        this.value = value;
    }

    @NotNull
    public static Replaceable<List<String>> of(String ... texts) {
        return Replaceable.of(Arrays.asList(texts));
    }

    @NotNull
    public static Replaceable<List<String>> of(@NotNull List<String> list) {
        return new Replaceable<List<String>>(list);
    }

    @NotNull
    public static Replaceable<String> of(@NotNull String text) {
        return new Replaceable<String>(text);
    }

    @NotNull
    public Replaceable<X> replace(@NotNull String regex, @NotNull Supplier<String> replace) {
        return this.replace(Collections.singletonMap(regex, replace));
    }

    @NotNull
    public Replaceable<X> replace(@NotNull Map<String, Supplier<String>> replaces) {
        this.replaces.putAll(replaces);
        return this;
    }

    @NotNull
    public Replaceable<X> replaces(String ... regex) {
        return this.replaces(Arrays.asList(regex));
    }

    @NotNull
    public Replaceable<X> replaces(@NotNull Collection<String> regex) {
        this.regex.addAll(regex);
        return this;
    }

    @NotNull
    public Replaceable<X> map(@NotNull UnaryOperator<X> map) {
        return this.map(Collections.singletonList(map));
    }

    @NotNull
    public Replaceable<X> map(@NotNull Collection<UnaryOperator<X>> map) {
        this.maps.addAll(map);
        return this;
    }

    @NotNull
    public X build(@NotNull String regex, @NotNull Supplier<String> replace) {
        return this.build(MapEntry.from(regex, replace));
    }

    @SafeVarargs
    @NotNull
    public final X build(Map.Entry<String, Supplier<String>> ... entries) {
        return this.build(Arrays.asList(entries));
    }

    @NotNull
    public X build(@NotNull Iterable<Map.Entry<String, Supplier<String>>> entries) {
        HashMap<String, Supplier<String>> map = new HashMap<String, Supplier<String>>();
        entries.forEach(entry -> {
            Supplier cfr_ignored_0 = (Supplier)map.put((String)entry.getKey(), (Supplier<String>)entry.getValue());
        });
        return this.build(map);
    }

    @NotNull
    public X build(@NotNull Map<String, Supplier<String>> replaces) {
        AtomicReference finalValue = new AtomicReference(this.value);
        this.replaces.forEach((s, replace) -> this.replace(finalValue, (CharSequence)s, (CharSequence)replace.get()));
        this.regex.forEach(r -> Optional.ofNullable(replaces.get(r)).ifPresent(s -> this.replace(finalValue, (CharSequence)r, (CharSequence)s.get())));
        this.maps.forEach(operator -> finalValue.set(operator.apply(finalValue.get())));
        return finalValue.get();
    }

    @NotNull
    public <Y> Y buildMap(@NotNull Function<X, Y> function) {
        X built = this.build();
        return function.apply(built);
    }

    @NotNull
    public X build() {
        return this.build(Collections.emptyMap());
    }

    @NotNull
    public <Y> Y buildMap(@NotNull Function<X, Y> function, @NotNull Map<String, Supplier<String>> replaces) {
        X built = this.build(replaces);
        return function.apply(built);
    }

    @NotNull
    public X getValue() {
        return this.value;
    }

    @NotNull
    public List<String> getRegex() {
        return Collections.unmodifiableList(this.regex);
    }

    @NotNull
    public Map<String, Supplier<String>> getReplaces() {
        return Collections.unmodifiableMap(this.replaces);
    }

    @NotNull
    public List<UnaryOperator<X>> getMaps() {
        return Collections.unmodifiableList(this.maps);
    }

    private void replace(@NotNull AtomicReference<X> finalValue, @NotNull CharSequence regex, @NotNull CharSequence replace) {
        if (this.value instanceof String) {
            finalValue.set(((String)finalValue.get()).replace(regex, replace));
        } else if (this.value instanceof List) {
            finalValue.set(new ListReplace((List)finalValue.get()).apply(regex, replace));
        }
    }

    public static final class Provider
    implements Provided<Replaceable<?>> {
        @Override
        public void set(@NotNull Replaceable<?> replaceable, @NotNull CfgSection section, @NotNull String path) {
            section.set(path, replaceable.getValue());
        }

        @Override
        @NotNull
        public Optional<Replaceable<?>> getWithField(@NotNull Replaceable<?> replaceable, @NotNull CfgSection section, @NotNull String path) {
            Optional<List<?>> listoptional;
            if (replaceable.getValue() instanceof String) {
                Optional<String> optionalstring = section.getString(path);
                Replaceable<?> genericreplaceable = replaceable;
                if (optionalstring.isPresent()) {
                    return Optional.of(Replaceable.of(optionalstring.get()).replaces(genericreplaceable.getRegex()).replace(genericreplaceable.getReplaces()).map(genericreplaceable.getMaps()));
                }
            } else if (replaceable.getValue() instanceof List && (listoptional = section.getList(path)).isPresent()) {
                Replaceable<?> genericreplaceable = replaceable;
                return Optional.of(Replaceable.of(listoptional.get()).replaces(genericreplaceable.getRegex()).replace(genericreplaceable.getReplaces()).map(genericreplaceable.getMaps()));
            }
            return Optional.empty();
        }

        @Override
        @NotNull
        public Optional<Replaceable<?>> get(@NotNull CfgSection section, @NotNull String path) {
            return Optional.empty();
        }
    }
}

