/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.jsonparser.Json;
import io.github.portlek.configs.jsonparser.JsonArray;
import io.github.portlek.configs.jsonparser.JsonObject;
import io.github.portlek.configs.jsonparser.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonHelper {
    private JsonHelper() {
    }

    @NotNull
    public static Optional<Object> jsonValueAsObject(@NotNull JsonValue value) {
        Object object = value.isBoolean() ? Boolean.valueOf(value.asBoolean()) : (value.isNumber() ? JsonHelper.parseNumber(value) : (value.isString() ? value.asString() : (value.isArray() ? JsonHelper.jsonArrayAsList(value.asArray()) : (value.isObject() ? JsonHelper.jsonObjectAsMap(value.asObject()) : null))));
        return Optional.ofNullable(object);
    }

    @NotNull
    public static List<Object> jsonArrayAsList(@NotNull JsonArray array) {
        ArrayList<Object> list = new ArrayList<Object>(array.size());
        for (JsonValue element : array) {
            JsonHelper.jsonValueAsObject(element).ifPresent(list::add);
        }
        return list;
    }

    @NotNull
    public static Map<String, Object> jsonObjectAsMap(@NotNull JsonValue value) {
        if (!(value instanceof JsonObject)) {
            return new HashMap<String, Object>();
        }
        JsonObject jsonObject = (JsonObject)value;
        HashMap<String, Object> map = new HashMap<String, Object>();
        jsonObject.forEach(member -> JsonHelper.jsonValueAsObject(member.getValue()).ifPresent(o -> map.put(member.getName(), o)));
        return map;
    }

    @NotNull
    public static Optional<JsonValue> objectAsJsonValue(@NotNull Object object) {
        JsonValue value = object instanceof Boolean ? Json.value((Boolean)object) : (object instanceof Integer ? Json.value((Integer)object) : (object instanceof Long ? Json.value((Long)object) : (object instanceof Float ? Json.value((Float)object) : (object instanceof Double ? Json.value((Double)object) : (object instanceof String ? Json.value((String)object) : (object instanceof Collection ? JsonHelper.collectionAsJsonArray((Collection)object) : (object instanceof Map ? JsonHelper.mapAsJsonObject((Map)object) : (object instanceof ConfigurationSection ? JsonHelper.mapAsJsonObject(((ConfigurationSection)object).getValues(false)) : null))))))));
        return Optional.ofNullable(value);
    }

    @NotNull
    public static JsonArray collectionAsJsonArray(@NotNull Iterable<?> collection) {
        JsonArray array = new JsonArray();
        collection.forEach(o -> JsonHelper.objectAsJsonValue(o).ifPresent(array::add));
        return array;
    }

    @NotNull
    public static JsonObject mapAsJsonObject(@NotNull Map<?, ?> map) {
        JsonObject object = new JsonObject();
        map.forEach((key, value) -> JsonHelper.objectAsJsonValue(value).ifPresent(jsonValue -> object.add(String.valueOf(key), (JsonValue)jsonValue)));
        return object;
    }

    @Nullable
    private static Object parseNumber(@NotNull JsonValue number) {
        try {
            Integer.parseInt(number.toString());
            return number.asInt();
        }
        catch (NumberFormatException e) {
            try {
                Long.parseLong(number.toString());
                return number.asLong();
            }
            catch (NumberFormatException e1) {
                try {
                    Double.parseDouble(number.toString());
                    return number.asDouble();
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        }
    }
}

