/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.processors;

import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.annotations.Value;
import io.github.portlek.configs.processors.Proceed;
import io.github.portlek.configs.util.PathCalc;
import io.github.portlek.configs.util.Provided;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class ValueProceed
implements Proceed<Field> {
    @NotNull
    private final FlManaged managed;
    @NotNull
    private final CfgSection parent;
    @NotNull
    private final Value value;

    public ValueProceed(@NotNull FlManaged mngd, @NotNull CfgSection cfgsctn, @NotNull Value vlue) {
        this.managed = mngd;
        this.parent = cfgsctn;
        this.value = vlue;
    }

    @Override
    public void load(@NotNull Field field) {
        String path = new PathCalc(this.value.regex(), this.value.separator(), this.value.path(), field.getName()).value();
        try {
            Optional<Object> optional = Optional.ofNullable(field.get(this.parent));
            if (!optional.isPresent()) {
                return;
            }
            Object fieldvalue = optional.get();
            Optional<?> filevalueoptional = this.get(fieldvalue, path);
            if (filevalueoptional.isPresent()) {
                field.set(this.parent, filevalueoptional.get());
            } else {
                this.set(fieldvalue, path);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    private Optional<?> get(@NotNull Object fieldvalue, @NotNull String path) {
        if (fieldvalue instanceof String) {
            return this.parent.getString(path);
        }
        if (fieldvalue instanceof List) {
            return this.parent.getList(path);
        }
        return this.managed.getCustomValue(fieldvalue.getClass()).map(objectProvided -> objectProvided.getWithField(fieldvalue, this.parent, path)).orElseGet(() -> this.parent.get(path));
    }

    private void set(@NotNull Object fieldValue, @NotNull String path) {
        Optional<Provided<?>> optional = this.managed.getCustomValue(fieldValue.getClass());
        if (optional.isPresent()) {
            optional.get().set(fieldValue, this.parent, path);
            return;
        }
        this.parent.set(path, fieldValue);
    }
}

