/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.processors;

import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.annotations.Instance;
import io.github.portlek.configs.annotations.Value;
import io.github.portlek.configs.processors.InstanceProceed;
import io.github.portlek.configs.processors.Proceed;
import io.github.portlek.configs.processors.ValueProceed;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class FieldsProceed
implements Proceed<FlManaged> {
    @NotNull
    private final CfgSection parent;

    public FieldsProceed(@NotNull CfgSection cnfsctn) {
        this.parent = cnfsctn;
    }

    @Override
    public void load(@NotNull FlManaged managed) {
        for (Field field : this.parent.getClass().getDeclaredFields()) {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Stream.of(Optional.ofNullable(field.getDeclaredAnnotation(Instance.class)).map(instance -> new InstanceProceed(managed, this.parent)), Optional.ofNullable(field.getDeclaredAnnotation(Value.class)).map(value -> new ValueProceed(managed, this.parent, (Value)value))).filter(Optional::isPresent).findFirst().filter(Optional::isPresent).map(Optional::get).ifPresent(fieldProceed -> fieldProceed.load(field));
            field.setAccessible(accessible);
        }
    }
}

