/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.jsonparser;

import io.github.portlek.configs.jsonparser.Json;
import io.github.portlek.configs.jsonparser.JsonArray;
import io.github.portlek.configs.jsonparser.JsonObject;
import io.github.portlek.configs.jsonparser.JsonWriter;
import io.github.portlek.configs.jsonparser.WriterConfig;
import io.github.portlek.configs.jsonparser.WritingBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;

public abstract class JsonValue
implements Serializable {
    public static final String NOT_AN_OBJECT = "Not an object: ";
    public static final String NOT_AN_ARRAY = "Not an array: ";
    public static final String NOT_A_NUMBER = "Not a number: ";
    public static final String NOT_A_STRING = "Not a string: ";
    public static final String NOT_A_BOOLEAN = "Not a boolean: ";

    JsonValue() {
    }

    @Deprecated
    public static JsonValue readFrom(Reader reader) throws IOException {
        return Json.parse(reader);
    }

    @Deprecated
    public static JsonValue readFrom(String text) {
        return Json.parse(text);
    }

    @Deprecated
    public static JsonValue valueOf(int value) {
        return Json.value(value);
    }

    @Deprecated
    public static JsonValue valueOf(long value) {
        return Json.value(value);
    }

    @Deprecated
    public static JsonValue valueOf(float value) {
        return Json.value(value);
    }

    @Deprecated
    public static JsonValue valueOf(double value) {
        return Json.value(value);
    }

    @Deprecated
    public static JsonValue valueOf(String string) {
        return Json.value(string);
    }

    @Deprecated
    public static JsonValue valueOf(boolean value) {
        return Json.value(value);
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public JsonObject asObject() {
        throw new UnsupportedOperationException(NOT_AN_OBJECT + this.toString());
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException(NOT_AN_ARRAY + this.toString());
    }

    public int asInt() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public long asLong() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public float asFloat() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public double asDouble() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public String asString() {
        throw new UnsupportedOperationException(NOT_A_STRING + this.toString());
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException(NOT_A_BOOLEAN + this.toString());
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, WriterConfig.MINIMAL);
    }

    public void writeTo(Writer writer, WriterConfig config) throws IOException {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        WritingBuffer buffer = new WritingBuffer(writer, 128);
        this.write(config.createWriter(buffer));
        buffer.flush();
    }

    public String toString(WriterConfig config) {
        StringWriter writer = new StringWriter();
        try {
            this.writeTo(writer, config);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return writer.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String toString() {
        return this.toString(WriterConfig.MINIMAL);
    }

    abstract void write(JsonWriter var1) throws IOException;
}

