/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.jsonparser;

import io.github.portlek.configs.jsonparser.Json;
import io.github.portlek.configs.jsonparser.JsonArray;
import io.github.portlek.configs.jsonparser.JsonObject;
import io.github.portlek.configs.jsonparser.JsonSerializable;
import io.github.portlek.configs.jsonparser.JsonValue;
import java.lang.reflect.Array;
import java.util.Map;

public final class JsonBuilder {
    public static JsonValue toJsonValue(Object object) {
        if (object == null) {
            return Json.NULL;
        }
        if (object instanceof JsonValue) {
            return (JsonValue)object;
        }
        if (object instanceof JsonSerializable) {
            return ((JsonSerializable)object).asJsonValue();
        }
        if (object instanceof Boolean) {
            return Json.value((Boolean)object);
        }
        if (object instanceof Byte) {
            return Json.value(((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return Json.value(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return Json.value((Integer)object);
        }
        if (object instanceof Long) {
            return Json.value((Long)object);
        }
        if (object instanceof Float) {
            return Json.value(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return Json.value((Double)object);
        }
        if (object.getClass().isArray()) {
            return JsonBuilder.arrayToJsonValue(object);
        }
        if (object instanceof Iterable) {
            return JsonBuilder.iterableToJsonValue((Iterable)object);
        }
        if (object instanceof Map) {
            return JsonBuilder.mapToJsonValue((Map)object);
        }
        return Json.value(String.valueOf(object));
    }

    static JsonArray iterableToJsonValue(Iterable<?> collection) {
        JsonArray array = new JsonArray();
        for (Object element : collection) {
            array.add(JsonBuilder.toJsonValue(element));
        }
        return array;
    }

    static JsonObject mapToJsonValue(Map<?, ?> map) {
        JsonObject object = new JsonObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            object.add(String.valueOf(entry.getKey()), JsonBuilder.toJsonValue(entry.getValue()));
        }
        return object;
    }

    static JsonValue arrayToJsonValue(Object inputArray) {
        JsonArray array = new JsonArray();
        int arrayLength = Array.getLength(inputArray);
        for (int i = 0; i < arrayLength; ++i) {
            Object element = Array.get(inputArray, i);
            array.add(JsonBuilder.toJsonValue(element));
        }
        return array;
    }
}

