/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.configuration;

import io.github.portlek.configs.configuration.Configuration;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.configuration.MemoryConfigurationOptions;
import io.github.portlek.configs.configuration.MemorySection;
import io.github.portlek.configs.util.Validate;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryConfiguration
extends MemorySection
implements Configuration {
    protected Configuration defaults;
    protected MemoryConfigurationOptions options;

    public MemoryConfiguration() {
    }

    public MemoryConfiguration(@Nullable Configuration defaults) {
        this.defaults = defaults;
    }

    @Override
    @Nullable
    public final ConfigurationSection getParent() {
        return null;
    }

    @Override
    public final void addDefault(@NotNull String path, @Nullable Object value) {
        Validate.notNull(path, "Path may not be null");
        if (this.defaults == null) {
            this.defaults = new MemoryConfiguration();
        }
        this.defaults.set(path, value);
    }

    @Override
    public final void addDefaults(@NotNull Map<String, Object> defaults) {
        Validate.notNull(defaults, "Defaults may not be null");
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            this.addDefault(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final void addDefaults(@NotNull Configuration defaults) {
        Validate.notNull(defaults, "Defaults may not be null");
        this.addDefaults(defaults.getValues(true));
    }

    @Override
    @Nullable
    public final Configuration getDefaults() {
        return this.defaults;
    }

    @Override
    public final void setDefaults(@NotNull Configuration defaults) {
        Validate.notNull(defaults, "Defaults may not be null");
        this.defaults = defaults;
    }

    @Override
    @NotNull
    public MemoryConfigurationOptions options() {
        if (this.options == null) {
            this.options = new MemoryConfigurationOptions(this);
        }
        return this.options;
    }
}

