/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.FileManaged;
import io.github.portlek.configs.LnkdFlManaged;
import io.github.portlek.configs.util.MapEntry;
import io.github.portlek.configs.yaml.FileConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class LinkedFileManaged
extends FileManaged
implements LnkdFlManaged {
    @NotNull
    private final Map<String, Map.Entry<File, FileConfiguration>> linkedFiles = new HashMap<String, Map.Entry<File, FileConfiguration>>();
    @NotNull
    private final Supplier<String> chosen;

    @SafeVarargs
    protected LinkedFileManaged(@NotNull Supplier<String> chosen, Map.Entry<String, Object> ... objects) {
        super(objects);
        this.chosen = chosen;
    }

    @Override
    @NotNull
    public final <T> T match(@NotNull Function<String, Optional<T>> function) {
        return function.apply(this.chosen.get()).orElseThrow(() -> new IllegalStateException("Cannot found match with the file key > " + this.chosen));
    }

    @Override
    @NotNull
    public final Supplier<String> getChosen() {
        return this.chosen;
    }

    @Override
    public final void setup(@NotNull File file, @NotNull FileConfiguration fileConfiguration) {
        super.setup(file, fileConfiguration);
        this.linkedFiles.put(this.chosen.get(), MapEntry.from(file, fileConfiguration));
    }
}

