/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.yaml;

import io.github.portlek.configs.configuration.InvalidConfigurationException;
import io.github.portlek.configs.configuration.MemoryConfiguration;
import io.github.portlek.configs.util.Validate;
import io.github.portlek.configs.yaml.FileConfigurationOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public abstract class FileConfiguration
extends MemoryConfiguration {
    protected FileConfiguration() {
    }

    public final void save(@NotNull File file) throws IOException {
        Validate.notNull(file, "File cannot be null");
        file.getParentFile().mkdirs();
        String data = this.saveToString();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write(data);
        }
    }

    @NotNull
    public abstract String saveToString();

    public final void load(@NotNull String file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        Validate.notNull(file, "File cannot be null");
        this.load(new File(file));
    }

    public final void load(@NotNull File file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        Validate.notNull(file, "File cannot be null");
        FileInputStream stream = new FileInputStream(file);
        this.load(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull Reader reader) throws IOException, InvalidConfigurationException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        this.loadFromString(builder.toString());
    }

    public abstract void loadFromString(@NotNull String var1) throws InvalidConfigurationException;

    @Override
    @NotNull
    public FileConfigurationOptions options() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }

    @NotNull
    protected abstract String buildHeader();
}

