/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.configuration.serialization.ConfigurationSerializable;
import io.github.portlek.configs.configuration.serialization.ConfigurationSerialization;
import io.github.portlek.configs.util.SerializableSet;
import io.github.portlek.configs.util.YAMLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class SerializationHelper {
    private static final Logger LOG = Logger.getLogger(SerializationHelper.class.getName());

    private SerializationHelper() {
    }

    public static Object serialize(@NotNull Object value) {
        Collection<Object> value1 = value;
        if (value1 instanceof Object[]) {
            value1 = new ArrayList<Object>(Arrays.asList((Object[])value1));
        }
        if (value1 instanceof Set && !(value1 instanceof SerializableSet)) {
            value1 = new SerializableSet((Set)value1);
        }
        if (value1 instanceof ConfigurationSection) {
            return SerializationHelper.buildMap(((ConfigurationSection)((Object)value1)).getValues(false));
        }
        if (value1 instanceof Map) {
            return SerializationHelper.buildMap((Map)((Object)value1));
        }
        if (value1 instanceof List) {
            return SerializationHelper.buildList(value1);
        }
        if (value1 instanceof ConfigurationSerializable) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)((Object)value1);
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values.putAll(serializable.serialize());
            return SerializationHelper.buildMap(values);
        }
        return value1;
    }

    public static Object deserialize(@NotNull Map<?, ?> input) {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>(input.size());
        for (Map.Entry<?, ?> e : input.entrySet()) {
            if (e.getValue() instanceof Map) {
                output.put(e.getKey().toString(), SerializationHelper.deserialize((Map)e.getValue()));
                continue;
            }
            if (e.getValue() instanceof List) {
                output.put(e.getKey().toString(), SerializationHelper.deserialize((List)e.getValue()));
                continue;
            }
            output.put(e.getKey().toString(), e.getValue());
        }
        if (output.containsKey("==")) {
            try {
                return ConfigurationSerialization.deserializeObject(output);
            }
            catch (IllegalArgumentException ex) {
                throw new YAMLException("Could not deserialize object", ex);
            }
        }
        return output;
    }

    @NotNull
    private static Map<String, Object> buildMap(@NotNull Map<?, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(map.size());
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                result.put(entry.getKey().toString(), SerializationHelper.serialize(entry.getValue()));
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error while building configuration map.", e);
        }
        return result;
    }

    private static List<Object> buildList(@NotNull Collection<?> collection) {
        ArrayList<Object> result = new ArrayList<Object>(collection.size());
        try {
            for (Object o : collection) {
                result.add(SerializationHelper.serialize(o));
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error while building configuration list.", e);
        }
        return result;
    }

    private static Object deserialize(@NotNull Collection<?> input) {
        ArrayList<Object> output = new ArrayList<Object>(input.size());
        for (Object o : input) {
            if (o instanceof Map) {
                output.add(SerializationHelper.deserialize((Map)o));
                continue;
            }
            if (o instanceof List) {
                output.add(SerializationHelper.deserialize((List)o));
                continue;
            }
            output.add(o);
        }
        return output;
    }
}

