/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class MapEntry<X, Y>
implements Map.Entry<X, Y> {
    @NotNull
    private final X key;
    @NotNull
    private final Y value;

    public MapEntry(@NotNull X xkey, @NotNull Y yvalue) {
        this.key = xkey;
        this.value = yvalue;
    }

    @NotNull
    public static <X, Y> Map.Entry<X, Y> from(@NotNull X xkey, @NotNull Y yvalue) {
        return new MapEntry<X, Y>(xkey, yvalue);
    }

    @Override
    @NotNull
    public X getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public Y getValue() {
        return this.value;
    }

    @Override
    public Y setValue(@NotNull Y yvalue) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is an immutable class, you can't edit it!");
    }

    @Override
    public int hashCode() {
        return this.key.hashCode() ^ this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Map.Entry && ((Map.Entry)obj).getKey().equals(this.key) && ((Map.Entry)obj).getValue().equals(this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

