/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import io.github.portlek.configs.json.JsonConfiguration;
import io.github.portlek.configs.yaml.FileConfiguration;
import io.github.portlek.configs.yaml.YamlConfiguration;
import java.io.File;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public enum FileType {
    YAML(".yml", YamlConfiguration::loadConfiguration),
    JSON(".json", JsonConfiguration::loadConfiguration);

    @NotNull
    public final String suffix;
    @NotNull
    private final Function<File, FileConfiguration> file;

    private FileType(String sffix, Function<File, FileConfiguration> fle) {
        this.suffix = sffix;
        this.file = fle;
    }

    @NotNull
    public FileConfiguration load(@NotNull File file) {
        return this.file.apply(file);
    }
}

