/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.jsonparser;

import io.github.portlek.configs.jsonparser.Json;
import io.github.portlek.configs.jsonparser.JsonValue;
import io.github.portlek.configs.jsonparser.JsonWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JsonObject
extends JsonValue
implements Iterable<Member> {
    private final List<String> names = new ArrayList<String>();
    private final List<JsonValue> values = new ArrayList<JsonValue>();
    private transient HashIndexTable table = new HashIndexTable();

    @Deprecated
    public static JsonObject readFrom(Reader reader) throws IOException {
        return JsonValue.readFrom(reader).asObject();
    }

    @Deprecated
    public static JsonObject readFrom(String string) {
        return JsonValue.readFrom(string).asObject();
    }

    public final JsonObject add(String name, JsonValue value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.table.add(name, this.names.size());
        this.names.add(name);
        this.values.add(value);
        return this;
    }

    public final JsonObject set(String name, int value) {
        this.set(name, Json.value(value));
        return this;
    }

    public final JsonObject set(String name, JsonValue value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        int index = this.indexOf(name);
        if (index == -1) {
            this.table.add(name, this.names.size());
            this.names.add(name);
            this.values.add(value);
        } else {
            this.values.set(index, value);
        }
        return this;
    }

    public final JsonObject set(String name, long value) {
        this.set(name, Json.value(value));
        return this;
    }

    public final JsonObject set(String name, float value) {
        this.set(name, Json.value(value));
        return this;
    }

    public final JsonObject set(String name, double value) {
        this.set(name, Json.value(value));
        return this;
    }

    public final JsonObject set(String name, boolean value) {
        this.set(name, Json.value(value));
        return this;
    }

    public final JsonObject set(String name, String value) {
        this.set(name, Json.value(value));
        return this;
    }

    public final JsonObject merge(Iterable<Member> object) {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        for (Member member : object) {
            this.set(member.name, member.value);
        }
        return this;
    }

    @Nullable
    public final JsonValue get(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        int index = this.indexOf(name);
        return index == -1 ? null : this.values.get(index);
    }

    @Override
    public final Iterator<Member> iterator() {
        final Iterator<String> namesIterator = this.names.iterator();
        final Iterator<JsonValue> valuesIterator = this.values.iterator();
        return new Iterator<Member>(){

            @Override
            public boolean hasNext() {
                return namesIterator.hasNext();
            }

            @Override
            public Member next() {
                String name = (String)namesIterator.next();
                JsonValue value = (JsonValue)valuesIterator.next();
                return new Member(name, value);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final boolean isObject() {
        return true;
    }

    @Override
    public final JsonObject asObject() {
        return this;
    }

    @Override
    final void write(JsonWriter writer) throws IOException {
        writer.writeObjectOpen();
        Iterator<String> namesIterator = this.names.iterator();
        Iterator<JsonValue> valuesIterator = this.values.iterator();
        if (namesIterator.hasNext()) {
            writer.writeMemberName(namesIterator.next());
            writer.writeMemberSeparator();
            valuesIterator.next().write(writer);
            while (namesIterator.hasNext()) {
                writer.writeObjectSeparator();
                writer.writeMemberName(namesIterator.next());
                writer.writeMemberSeparator();
                valuesIterator.next().write(writer);
            }
        }
        writer.writeObjectClose();
    }

    public final int hashCode() {
        int result = 1;
        result = 31 * result + this.names.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        return this.names.equals(other.names) && this.values.equals(other.values);
    }

    final int indexOf(String name) {
        int index = this.table.get(name);
        if (index != -1 && name.equals(this.names.get(index))) {
            return index;
        }
        return this.names.lastIndexOf(name);
    }

    private void updateHashIndex() {
        int size = this.names.size();
        for (int i = 0; i < size; ++i) {
            this.table.add(this.names.get(i), i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        JsonObject jsonObject = this;
        synchronized (jsonObject) {
            inputStream.defaultReadObject();
            this.table = new HashIndexTable();
            this.updateHashIndex();
        }
    }

    static class HashIndexTable {
        private final byte[] hashTable = new byte[32];

        HashIndexTable() {
        }

        final void add(String name, int index) {
            int slot = this.hashSlotFor(name);
            this.hashTable[slot] = index < 255 ? (byte)(index + 1) : (byte)0;
        }

        final int get(Object name) {
            int slot = this.hashSlotFor(name);
            return (this.hashTable[slot] & 0xFF) - 1;
        }

        private int hashSlotFor(Object element) {
            return element.hashCode() & this.hashTable.length - 1;
        }
    }

    public static class Member {
        private final String name;
        private final JsonValue value;

        Member(String name, JsonValue value) {
            this.name = name;
            this.value = value;
        }

        public final String getName() {
            return this.name;
        }

        public final JsonValue getValue() {
            return this.value;
        }

        public final int hashCode() {
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!this.getClass().equals(object.getClass())) {
                return false;
            }
            Member other = (Member)object;
            return this.name.equals(other.name) && this.value.equals(other.value);
        }
    }
}

