/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.jsonparser;

import io.github.portlek.configs.jsonparser.JsonArray;
import io.github.portlek.configs.jsonparser.JsonHandler;
import io.github.portlek.configs.jsonparser.JsonLiteral;
import io.github.portlek.configs.jsonparser.JsonNumber;
import io.github.portlek.configs.jsonparser.JsonObject;
import io.github.portlek.configs.jsonparser.JsonParser;
import io.github.portlek.configs.jsonparser.JsonString;
import io.github.portlek.configs.jsonparser.JsonValue;
import java.io.IOException;
import java.io.Reader;

public final class Json {
    public static final JsonValue NULL = new JsonLiteral("null");
    public static final JsonValue TRUE = new JsonLiteral("true");
    public static final JsonValue FALSE = new JsonLiteral("false");

    private Json() {
    }

    public static JsonValue value(int value) {
        return new JsonNumber(Integer.toString(value, 10));
    }

    public static JsonValue value(long value) {
        return new JsonNumber(Long.toString(value, 10));
    }

    public static JsonValue value(float value) {
        if (Float.isInfinite(value) || Float.isNaN(value)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Float.toString(value));
    }

    public static JsonValue value(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Double.toString(value));
    }

    public static JsonValue value(String string) {
        return string == null ? NULL : new JsonString(string);
    }

    public static JsonValue value(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static JsonValue parse(String string) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        DefaultHandler handler = new DefaultHandler();
        new JsonParser(handler).parse(string);
        return handler.getValue();
    }

    public static JsonValue parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        DefaultHandler handler = new DefaultHandler();
        new JsonParser(handler).parse(reader);
        return handler.getValue();
    }

    static class DefaultHandler
    extends JsonHandler<JsonArray, JsonObject> {
        protected JsonValue value;

        DefaultHandler() {
        }

        @Override
        public final void endNull() {
            this.value = NULL;
        }

        @Override
        public final void endBoolean(boolean bool) {
            this.value = bool ? TRUE : FALSE;
        }

        @Override
        public final void endString(String string) {
            this.value = new JsonString(string);
        }

        @Override
        public final void endNumber(String string) {
            this.value = new JsonNumber(string);
        }

        @Override
        public final JsonArray startArray() {
            return new JsonArray();
        }

        @Override
        public final void endArray(JsonArray array) {
            this.value = array;
        }

        @Override
        public final void endArrayValue(JsonArray array) {
            array.add(this.value);
        }

        @Override
        public final JsonObject startObject() {
            return new JsonObject();
        }

        @Override
        public final void endObject(JsonObject object) {
            this.value = object;
        }

        @Override
        public final void endObjectValue(JsonObject object, String name) {
            object.add(name, this.value);
        }

        final JsonValue getValue() {
            return this.value;
        }
    }
}

