/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.json;

import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.configuration.InvalidConfigurationException;
import io.github.portlek.configs.json.JsonConfigurationOptions;
import io.github.portlek.configs.jsonparser.Json;
import io.github.portlek.configs.jsonparser.JsonObject;
import io.github.portlek.configs.jsonparser.WriterConfig;
import io.github.portlek.configs.util.JsonHelper;
import io.github.portlek.configs.util.SerializationHelper;
import io.github.portlek.configs.yaml.FileConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class JsonConfiguration
extends FileConfiguration {
    private static final String BLANK_CONFIG = "{}\n";
    private static final Logger LOG = Logger.getLogger(JsonConfiguration.class.getName());

    public static JsonConfiguration loadConfiguration(@NotNull File file) {
        return JsonConfiguration.loadConfiguration(new JsonConfiguration(), file);
    }

    private static JsonConfiguration loadConfiguration(@NotNull JsonConfiguration config, @NotNull File file) {
        try {
            config.load(file);
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.SEVERE, "Cannot find file " + file, ex);
        }
        catch (InvalidConfigurationException | IOException ex) {
            LOG.log(Level.SEVERE, "Cannot load " + file, ex);
        }
        return config;
    }

    @Override
    @NotNull
    public String saveToString() {
        JsonObject jsonObject = JsonHelper.mapAsJsonObject(this.getValues(false));
        String dump = jsonObject.toString(WriterConfig.PRETTY_PRINT);
        if (dump.equals(BLANK_CONFIG)) {
            return "";
        }
        return dump;
    }

    @Override
    public void loadFromString(@NotNull String contents) {
        if (contents.isEmpty()) {
            return;
        }
        this.convertMapsToSections(JsonHelper.jsonObjectAsMap(Json.parse(contents)), this);
    }

    @Override
    @NotNull
    public JsonConfigurationOptions options() {
        if (this.options == null) {
            this.options = new JsonConfigurationOptions(this);
        }
        return (JsonConfigurationOptions)this.options;
    }

    @Override
    @NotNull
    protected String buildHeader() {
        return "";
    }

    private void convertMapsToSections(@NotNull Map<?, ?> input, @NotNull ConfigurationSection section) {
        Map input1 = input;
        Object result = SerializationHelper.deserialize(input1);
        if (result instanceof Map) {
            input1 = (Map)result;
            for (Map.Entry entry : input1.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    this.convertMapsToSections((Map)value, section.createSection(key));
                    continue;
                }
                section.set(key, value);
            }
        } else {
            section.set("", result);
        }
    }
}

