/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.processors;

import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.annotations.Instance;
import io.github.portlek.configs.annotations.Value;
import io.github.portlek.configs.processors.InstanceProceed;
import io.github.portlek.configs.processors.Proceed;
import io.github.portlek.configs.processors.ValueProceed;
import java.lang.reflect.Field;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class FieldsProceed
implements Proceed<FlManaged> {
    @NotNull
    private final CfgSection parent;

    public FieldsProceed(@NotNull CfgSection cnfsctn) {
        this.parent = cnfsctn;
    }

    @Override
    public void load(@NotNull FlManaged managed) {
        for (Field field : this.parent.getClass().getDeclaredFields()) {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Optional.ofNullable(field.getDeclaredAnnotation(Instance.class)).map(instance -> Optional.of(new InstanceProceed(managed, this.parent))).orElseGet(() -> Optional.ofNullable(field.getDeclaredAnnotation(Value.class)).flatMap(value -> Optional.of(new ValueProceed(managed, this.parent, (Value)value)))).ifPresent(proceed -> proceed.load(field));
            field.setAccessible(accessible);
        }
    }
}

