/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.processors;

import io.github.portlek.configs.FlManaged;
import io.github.portlek.configs.annotations.Config;
import io.github.portlek.configs.processors.FieldsProceed;
import io.github.portlek.configs.processors.Proceed;
import io.github.portlek.configs.util.AddSeparator;
import io.github.portlek.configs.util.Basedir;
import io.github.portlek.configs.util.FileType;
import io.github.portlek.configs.util.SaveResource;
import io.github.portlek.configs.util.Version;
import io.github.portlek.configs.yaml.FileConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class ConfigProceed
implements Proceed<FlManaged> {
    @NotNull
    private final Config config;

    public ConfigProceed(@NotNull Config cnfg) {
        this.config = cnfg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(@NotNull FlManaged managed) {
        FileType type = this.config.type();
        String name = this.config.name().endsWith(type.suffix) ? this.config.name() : this.config.name() + type.suffix;
        Version version = Version.of(this.config.version());
        String versionpath = this.config.versionPath();
        Optional<File> optional = new Basedir(managed.getClass()).value();
        if (!optional.isPresent()) {
            return;
        }
        File basedir = optional.get();
        String filelocation = new AddSeparator(this.config.location().replace("%basedir%", basedir.getParentFile().getAbsolutePath()).replace("/", File.separator)).value();
        String jarlocation = new AddSeparator(this.config.location().replace("%basedir%", basedir.getAbsolutePath()).replace("/", File.separator)).value();
        File file = this.config.copyDefault() ? new SaveResource(jarlocation, new AddSeparator(this.config.resourcePath()).value() + name).value() : new File(filelocation, name);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfiguration configuration = type.load(file);
        managed.setup(file, configuration);
        Optional<String> versionoptional = managed.getString(versionpath);
        if (versionoptional.isPresent()) {
            Version fileversion = Version.of(versionoptional.get());
            if (version.is(fileversion)) {
                // empty if block
            }
        } else {
            version.write(versionpath, managed);
        }
        new FieldsProceed(managed).load(managed);
        managed.save();
    }
}

