/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.jsonparser;

import io.github.portlek.configs.jsonparser.JsonValue;
import io.github.portlek.configs.jsonparser.JsonWriter;
import java.io.IOException;

class JsonLiteral
extends JsonValue {
    private final String value;
    private final boolean isNull;
    private final boolean isTrue;
    private final boolean isFalse;

    JsonLiteral(String value) {
        this.value = value;
        this.isNull = "null".equals(value);
        this.isTrue = "true".equals(value);
        this.isFalse = "false".equals(value);
    }

    @Override
    public final boolean isBoolean() {
        return this.isTrue || this.isFalse;
    }

    @Override
    public final boolean isTrue() {
        return this.isTrue;
    }

    @Override
    public final boolean isFalse() {
        return this.isFalse;
    }

    @Override
    public final boolean isNull() {
        return this.isNull;
    }

    @Override
    public final boolean asBoolean() {
        return this.isNull ? super.asBoolean() : this.isTrue;
    }

    @Override
    public final String toString() {
        return this.value;
    }

    @Override
    final void write(JsonWriter writer) throws IOException {
        writer.writeLiteral(this.value);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        JsonLiteral other = (JsonLiteral)object;
        return this.value.equals(other.value);
    }
}

